"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    filter_: List = None,
    max_duration: int = None,
    max_results: int = None,
    min_duration: int = None,
    next_token: str = None,
    offering_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the Dedicated Host reservations that are available to purchase. The results describe all of the Dedicated Host reservation offerings, including offerings that might not match the instance family and Region of your Dedicated Hosts. When purchasing an offering, ensure that the instance family and Region of the offering matches that of the Dedicated Hosts with which it is to be associated. For more information about supported instance types, see Dedicated Hosts in the Amazon EC2 User Guide.

    Args:
        filter_(List, optional): The filters.    instance-family - The instance family of the offering (for example, m4).    payment-option - The payment option (NoUpfront | PartialUpfront | AllUpfront).  . Defaults to None.
        max_duration(int, optional): This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years. Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error. Defaults to None.
        min_duration(int, optional): This is the minimum duration of the reservation you'd like to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one year. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.
        offering_id(str, optional): The ID of the reservation offering. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.host.reservation.offering.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.host.reservation.offering.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_host_reservation_offerings",
        op_kwargs={
            "Filter": filter_,
            "MaxDuration": max_duration,
            "MaxResults": max_results,
            "MinDuration": min_duration,
            "NextToken": next_token,
            "OfferingId": offering_id,
        },
    )
