"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    filter_: List = None,
    host_reservation_id_set: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes reservations that are associated with Dedicated Hosts in your account.

    Args:
        filter_(List, optional): The filters.    instance-family - The instance family (for example, m4).    payment-option - The payment option (NoUpfront | PartialUpfront | AllUpfront).    state - The state of the reservation (payment-pending | payment-failed | active | retired).    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        host_reservation_id_set(List, optional): The host reservation IDs. Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.host.reservation.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.host.reservation.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_host_reservations",
        op_kwargs={
            "Filter": filter_,
            "HostReservationIdSet": host_reservation_id_set,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def purchase(
    hub,
    ctx,
    host_id_set: List,
    offering_id: str,
    client_token: str = None,
    currency_code: str = None,
    limit_price: str = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Purchase a reservation with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This action results in the specified reservation being purchased and charged to your account.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Defaults to None.
        currency_code(str, optional): The currency in which the totalUpfrontPrice, LimitPrice, and totalHourlyPrice amounts are specified. At this time, the only supported currency is USD. Defaults to None.
        host_id_set(List): The IDs of the Dedicated Hosts with which the reservation will be associated.
        limit_price(str, optional): The specified limit is checked against the total upfront cost of the reservation (calculated as the offering's upfront cost multiplied by the host count). If the total upfront cost is greater than the specified price limit, the request fails. This is used to ensure that the purchase does not exceed the expected upfront cost of the purchase. At this time, the only supported currency is USD. For example, to indicate a limit price of USD 100, specify 100.00. Defaults to None.
        offering_id(str): The ID of the offering.
        tag_specifications(List, optional): The tags to apply to the Dedicated Host Reservation during purchase. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.host.reservation.init.purchase(
                ctx, host_id_set=value, offering_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.host.reservation.init.purchase host_id_set=value, offering_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="purchase_host_reservation",
        op_kwargs={
            "ClientToken": client_token,
            "CurrencyCode": currency_code,
            "HostIdSet": host_id_set,
            "LimitPrice": limit_price,
            "OfferingId": offering_id,
            "TagSpecifications": tag_specifications,
        },
    )
