"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def allocate(
    hub,
    ctx,
    availability_zone: str,
    quantity: int,
    auto_placement: str = None,
    client_token: str = None,
    instance_type: str = None,
    instance_family: str = None,
    tag_specifications: List = None,
    host_recovery: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family, the Availability Zone in which to allocate the host, and the number of hosts to allocate.

    Args:
        auto_placement(str, optional): Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see  Understanding auto-placement and affinity in the Amazon EC2 User Guide. Default: on . Defaults to None.
        availability_zone(str): The Availability Zone in which to allocate the Dedicated Host.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Defaults to None.
        instance_type(str, optional): Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only. If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this parameter and specify InstanceFamily instead. You cannot specify InstanceType and InstanceFamily in the same request. Defaults to None.
        instance_family(str, optional): Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family. If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify InstanceType instead. You cannot specify InstanceFamily and InstanceType in the same request. Defaults to None.
        quantity(int): The number of Dedicated Hosts to allocate to your account with these parameters.
        tag_specifications(List, optional): The tags to apply to the Dedicated Host during creation. Defaults to None.
        host_recovery(str, optional): Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by default. For more information, see  Host recovery in the Amazon EC2 User Guide. Default: off . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.host.init.allocate(
                ctx, availability_zone=value, quantity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.host.init.allocate availability_zone=value, quantity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="allocate_hosts",
        op_kwargs={
            "AutoPlacement": auto_placement,
            "AvailabilityZone": availability_zone,
            "ClientToken": client_token,
            "InstanceType": instance_type,
            "InstanceFamily": instance_family,
            "Quantity": quantity,
            "TagSpecifications": tag_specifications,
            "HostRecovery": host_recovery,
        },
    )


async def describe_all(
    hub,
    ctx,
    filter_: List = None,
    host_ids: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified Dedicated Hosts or all your Dedicated Hosts. The results describe only the Dedicated Hosts in the Region you're currently using. All listed instances consume capacity on your Dedicated Host. Dedicated Hosts that have recently been released are listed with the state released.

    Args:
        filter_(List, optional): The filters.    auto-placement - Whether auto-placement is enabled or disabled (on | off).    availability-zone - The Availability Zone of the host.    client-token - The idempotency token that you provided when you allocated the host.    host-reservation-id - The ID of the reservation assigned to this host.    instance-type - The instance type size that the Dedicated Host is configured to support.    state - The allocation state of the Dedicated Host (available | under-assessment | permanent-failure | released | released-permanent-failure).    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        host_ids(List, optional): The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches. Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error. You cannot specify this parameter and the host IDs parameter in the same request. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.host.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.host.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_hosts",
        op_kwargs={
            "Filter": filter_,
            "HostIds": host_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def modify(
    hub,
    ctx,
    host_ids: List,
    auto_placement: str = None,
    host_recovery: str = None,
    instance_type: str = None,
    instance_family: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled, any instances that you launch with a tenancy of host but without a specific host ID are placed onto any available Dedicated Host in your account that has auto-placement enabled. When auto-placement is disabled, you need to provide a host ID to have the instance launch onto a specific host. If no host ID is provided, the instance is launched onto a suitable host with auto-placement enabled. You can also use this API action to modify a Dedicated Host to support either multiple instance types in an instance family, or to support a specific instance type only.

    Args:
        auto_placement(str, optional): Specify whether to enable or disable auto-placement. Defaults to None.
        host_ids(List): The IDs of the Dedicated Hosts to modify.
        host_recovery(str, optional): Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see  Host recovery in the Amazon EC2 User Guide. Defaults to None.
        instance_type(str, optional): Specifies the instance type to be supported by the Dedicated Host. Specify this parameter to modify a Dedicated Host to support only a specific instance type. If you want to modify a Dedicated Host to support multiple instance types in its current instance family, omit this parameter and specify InstanceFamily instead. You cannot specify InstanceType and InstanceFamily in the same request. Defaults to None.
        instance_family(str, optional): Specifies the instance family to be supported by the Dedicated Host. Specify this parameter to modify a Dedicated Host to support multiple instance types within its current instance family. If you want to modify a Dedicated Host to support a specific instance type only, omit this parameter and specify InstanceType instead. You cannot specify InstanceFamily and InstanceType in the same request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.host.init.modify(ctx, host_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.host.init.modify host_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_hosts",
        op_kwargs={
            "AutoPlacement": auto_placement,
            "HostIds": host_ids,
            "HostRecovery": host_recovery,
            "InstanceType": instance_type,
            "InstanceFamily": instance_family,
        },
    )


async def release(hub, ctx, host_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    When you no longer want to use an On-Demand Dedicated Host it can be released. On-Demand billing is stopped and the host goes into released state. The host ID of Dedicated Hosts that have been released can no longer be specified in another request, for example, to modify the host. You must stop or terminate all instances on a host before it can be released. When Dedicated Hosts are released, it may take some time for them to stop counting toward your limit and you may receive capacity errors when trying to allocate new Dedicated Hosts. Wait a few minutes and then try again. Released hosts still appear in a DescribeHosts response.

    Args:
        host_ids(List): The IDs of the Dedicated Hosts to release.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.host.init.release(ctx, host_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.host.init.release host_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="release_hosts",
        op_kwargs={"HostIds": host_ids},
    )
