"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    capacity_reservation_id: str,
    next_token: str = None,
    max_results: int = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the resource groups to which a Capacity Reservation has been added.

    Args:
        capacity_reservation_id(str): The ID of the Capacity Reservation.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.group_for_capacity_reservation.get(
                ctx, capacity_reservation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.group_for_capacity_reservation.get capacity_reservation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_groups_for_capacity_reservation",
        op_kwargs={
            "CapacityReservationId": capacity_reservation_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "DryRun": dry_run,
        },
    )
