"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_fpga_image_id: str,
    source_region: str,
    dry_run: bool = None,
    description: str = None,
    name: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies the specified Amazon FPGA Image (AFI) to the current Region.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        source_fpga_image_id(str): The ID of the source AFI.
        description(str, optional): The description for the new AFI. Defaults to None.
        name(str, optional): The name for the new AFI. The default is the name of the source AFI. Defaults to None.
        source_region(str): The Region that contains the source AFI.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fpga_image.init.copy(
                ctx, source_fpga_image_id=value, source_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fpga_image.init.copy source_fpga_image_id=value, source_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="copy_fpga_image",
        op_kwargs={
            "DryRun": dry_run,
            "SourceFpgaImageId": source_fpga_image_id,
            "Description": description,
            "Name": name,
            "SourceRegion": source_region,
            "ClientToken": client_token,
        },
    )


async def create(
    hub,
    ctx,
    input_storage_location: Dict,
    dry_run: bool = None,
    logs_storage_location: Dict = None,
    description: str = None,
    name: str = None,
    client_token: str = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP). The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs. An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on multiple FPGA-accelerated instances. For more information, see the AWS FPGA Hardware Development Kit.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        input_storage_location(Dict): The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
        logs_storage_location(Dict, optional): The location in Amazon S3 for the output logs. Defaults to None.
        description(str, optional): A description for the AFI. Defaults to None.
        name(str, optional): A name for the AFI. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the FPGA image during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fpga_image.init.create(ctx, input_storage_location=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fpga_image.init.create input_storage_location=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_fpga_image",
        op_kwargs={
            "DryRun": dry_run,
            "InputStorageLocation": input_storage_location,
            "LogsStorageLocation": logs_storage_location,
            "Description": description,
            "Name": name,
            "ClientToken": client_token,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete(hub, ctx, fpga_image_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Amazon FPGA Image (AFI).

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        fpga_image_id(str): The ID of the AFI.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fpga_image.init.delete(ctx, fpga_image_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fpga_image.init.delete fpga_image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_fpga_image",
        op_kwargs={"DryRun": dry_run, "FpgaImageId": fpga_image_id},
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    fpga_image_ids: List = None,
    owners: List = None,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own, and AFIs owned by other AWS accounts for which you have load permissions.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        fpga_image_ids(List, optional): The AFI IDs. Defaults to None.
        owners(List, optional): Filters the AFI by owner. Specify an AWS account ID, self (owner is the sender of the request), or an AWS owner alias (valid values are amazon | aws-marketplace). Defaults to None.
        filters(List, optional): The filters.    create-time - The creation time of the AFI.    fpga-image-id - The FPGA image identifier (AFI ID).    fpga-image-global-id - The global FPGA image identifier (AGFI ID).    name - The name of the AFI.    owner-id - The AWS account ID of the AFI owner.    product-code - The product code.    shell-version - The version of the AWS Shell that was used to create the bitstream.    state - The state of the AFI (pending | failed | available | unavailable).    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    update-time - The time of the most recent update.  . Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fpga_image.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fpga_image.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_fpga_images",
        op_kwargs={
            "DryRun": dry_run,
            "FpgaImageIds": fpga_image_ids,
            "Owners": owners,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
