"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub, ctx, fpga_image_id: str, attribute: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified attribute of the specified Amazon FPGA Image (AFI).

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        fpga_image_id(str): The ID of the AFI.
        attribute(str): The AFI attribute.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fpga_image.attribute.describe(
                ctx, fpga_image_id=value, attribute=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fpga_image.attribute.describe fpga_image_id=value, attribute=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_fpga_image_attribute",
        op_kwargs={
            "DryRun": dry_run,
            "FpgaImageId": fpga_image_id,
            "Attribute": attribute,
        },
    )


async def modify(
    hub,
    ctx,
    fpga_image_id: str,
    dry_run: bool = None,
    attribute: str = None,
    operation_type: str = None,
    user_ids: List = None,
    user_groups: List = None,
    product_codes: List = None,
    load_permission: Dict = None,
    description: str = None,
    name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified attribute of the specified Amazon FPGA Image (AFI).

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        fpga_image_id(str): The ID of the AFI.
        attribute(str, optional): The name of the attribute. Defaults to None.
        operation_type(str, optional): The operation type. Defaults to None.
        user_ids(List, optional): The AWS account IDs. This parameter is valid only when modifying the loadPermission attribute. Defaults to None.
        user_groups(List, optional): The user groups. This parameter is valid only when modifying the loadPermission attribute. Defaults to None.
        product_codes(List, optional): The product codes. After you add a product code to an AFI, it can't be removed. This parameter is valid only when modifying the productCodes attribute. Defaults to None.
        load_permission(Dict, optional): The load permission for the AFI. Defaults to None.
        description(str, optional): A description for the AFI. Defaults to None.
        name(str, optional): A name for the AFI. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fpga_image.attribute.modify(ctx, fpga_image_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fpga_image.attribute.modify fpga_image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_fpga_image_attribute",
        op_kwargs={
            "DryRun": dry_run,
            "FpgaImageId": fpga_image_id,
            "Attribute": attribute,
            "OperationType": operation_type,
            "UserIds": user_ids,
            "UserGroups": user_groups,
            "ProductCodes": product_codes,
            "LoadPermission": load_permission,
            "Description": description,
            "Name": name,
        },
    )


async def reset(
    hub, ctx, fpga_image_id: str, dry_run: bool = None, attribute: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Resets the specified attribute of the specified Amazon FPGA Image (AFI) to its default value. You can only reset the load permission attribute.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        fpga_image_id(str): The ID of the AFI.
        attribute(str, optional): The attribute. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fpga_image.attribute.reset(ctx, fpga_image_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fpga_image.attribute.reset fpga_image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reset_fpga_image_attribute",
        op_kwargs={
            "DryRun": dry_run,
            "FpgaImageId": fpga_image_id,
            "Attribute": attribute,
        },
    )
