"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    flow_log_id: str,
    config_delivery_s3_destination_arn: str,
    integrate_services: Dict,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Generates a CloudFormation template that streamlines and automates the integration of VPC flow logs with Amazon Athena. This make it easier for you to query and gain insights from VPC flow logs data. Based on the information that you provide, we configure resources in the template to do the following:   Create a table in Athena that maps fields to a custom log format   Create a Lambda function that updates the table with new partitions on a daily, weekly, or monthly basis   Create a table partitioned between two timestamps in the past   Create a set of named queries in Athena that you can use to get started quickly

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        flow_log_id(str): The ID of the flow log.
        config_delivery_s3_destination_arn(str): To store the CloudFormation template in Amazon S3, specify the location in Amazon S3.
        integrate_services(Dict): Information about the service integration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.flow_logs_integration_template.get(
                ctx,
                flow_log_id=value,
                config_delivery_s3_destination_arn=value,
                integrate_services=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.flow_logs_integration_template.get flow_log_id=value, config_delivery_s3_destination_arn=value, integrate_services=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_flow_logs_integration_template",
        op_kwargs={
            "DryRun": dry_run,
            "FlowLogId": flow_log_id,
            "ConfigDeliveryS3DestinationArn": config_delivery_s3_destination_arn,
            "IntegrateServices": integrate_services,
        },
    )
