"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub,
    ctx,
    resource_ids: List,
    resource_type: str,
    traffic_type: str,
    dry_run: bool = None,
    client_token: str = None,
    deliver_logs_permission_arn: str = None,
    log_group_name: str = None,
    log_destination_type: str = None,
    log_destination: str = None,
    log_format: str = None,
    tag_specifications: List = None,
    max_aggregation_interval: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet, or VPC.  Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting of fields that describe the traffic flow. For more information, see Flow log records in the Amazon Virtual Private Cloud User Guide. When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored network interfaces are published to a single log file object that is stored in the specified bucket. For more information, see VPC Flow Logs in the Amazon Virtual Private Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency. Defaults to None.
        deliver_logs_permission_arn(str, optional): The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account. If you specify LogDestinationType as s3, do not specify DeliverLogsPermissionArn or LogGroupName. Defaults to None.
        log_group_name(str, optional): The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs. If you specify LogDestinationType as s3, do not specify DeliverLogsPermissionArn or LogGroupName. Defaults to None.
        resource_ids(List): The ID of the subnet, network interface, or VPC for which you want to create a flow log. Constraints: Maximum of 1000 resources.
        resource_type(str): The type of resource for which to create the flow log. For example, if you specified a VPC ID for the ResourceId property, specify VPC for this property.
        traffic_type(str): The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.
        log_destination_type(str, optional): Specifies the type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify cloud-watch-logs. To publish flow log data to Amazon S3, specify s3. If you specify LogDestinationType as s3, do not specify DeliverLogsPermissionArn or LogGroupName. Default: cloud-watch-logs . Defaults to None.
        log_destination(str, optional): Specifies the destination to which the flow log data is to be published. Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for LogDestinationType. If LogDestinationType is not specified or cloud-watch-logs, specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called my-logs, specify arn:aws:logs:us-east-1:123456789012:log-group:my-logs. Alternatively, use LogGroupName instead. If LogDestinationType is s3, specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: bucket_ARN/subfolder_name/. For example, to specify a subfolder named my-logs in a bucket named my-bucket, use the following ARN: arn:aws:s3:::my-bucket/my-logs/. You cannot use AWSLogs as a subfolder name. This is a reserved term. Defaults to None.
        log_format(str, optional): The fields to include in the flow log record, in the order in which they should appear. For a list of available fields, see Flow log records. If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field. Specify the fields using the ${field-id} format, separated by spaces. For the CLI, use single quotation marks (' ') to surround the parameter value. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the flow logs. Defaults to None.
        max_aggregation_interval(int, optional): The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes). When a network interface is attached to a Nitro-based instance, the aggregation interval is always 60 seconds or less, regardless of the value that you specify. Default: 600. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.flow_log.create_multiple(
                ctx, resource_ids=value, resource_type=value, traffic_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.flow_log.create_multiple resource_ids=value, resource_type=value, traffic_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_flow_logs",
        op_kwargs={
            "DryRun": dry_run,
            "ClientToken": client_token,
            "DeliverLogsPermissionArn": deliver_logs_permission_arn,
            "LogGroupName": log_group_name,
            "ResourceIds": resource_ids,
            "ResourceType": resource_type,
            "TrafficType": traffic_type,
            "LogDestinationType": log_destination_type,
            "LogDestination": log_destination,
            "LogFormat": log_format,
            "TagSpecifications": tag_specifications,
            "MaxAggregationInterval": max_aggregation_interval,
        },
    )


async def delete_multiple(hub, ctx, flow_log_ids: List, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more flow logs.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        flow_log_ids(List): One or more flow log IDs. Constraint: Maximum of 1000 flow log IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.flow_log.delete_multiple(ctx, flow_log_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.flow_log.delete_multiple flow_log_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_flow_logs",
        op_kwargs={"DryRun": dry_run, "FlowLogIds": flow_log_ids},
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    filter_: List = None,
    flow_log_ids: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more flow logs. To view the information in your flow logs (the log streams for the network interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs API.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filter_(List, optional): One or more filters.    deliver-log-status - The status of the logs delivery (SUCCESS | FAILED).    log-destination-type - The type of destination to which the flow log publishes data. Possible destination types include cloud-watch-logs and s3.    flow-log-id - The ID of the flow log.    log-group-name - The name of the log group.    resource-id - The ID of the VPC, subnet, or network interface.    traffic-type - The type of traffic (ACCEPT | REJECT | ALL).    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        flow_log_ids(List, optional): One or more flow log IDs. Constraint: Maximum of 1000 flow log IDs. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.flow_log.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.flow_log.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_flow_logs",
        op_kwargs={
            "DryRun": dry_run,
            "Filter": filter_,
            "FlowLogIds": flow_log_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
