"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    launch_template_configs: List,
    target_capacity_specification: Dict,
    dry_run: bool = None,
    client_token: str = None,
    spot_options: Dict = None,
    on_demand_options: Dict = None,
    excess_capacity_termination_policy: str = None,
    terminate_instances_with_expiration: bool = None,
    type_: str = None,
    valid_from: str = None,
    valid_until: str = None,
    replace_unhealthy_instances: bool = None,
    tag_specifications: List = None,
    context: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Launches an EC2 Fleet. You can create a single EC2 Fleet that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet. For more information, see Launching an EC2 Fleet in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensuring Idempotency. Defaults to None.
        spot_options(Dict, optional): Describes the configuration of Spot Instances in an EC2 Fleet. Defaults to None.
        on_demand_options(Dict, optional): Describes the configuration of On-Demand Instances in an EC2 Fleet. Defaults to None.
        excess_capacity_termination_policy(str, optional): Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet. Defaults to None.
        launch_template_configs(List): The configuration for the EC2 Fleet.
        target_capacity_specification(Dict): The number of units to request.
        terminate_instances_with_expiration(bool, optional): Indicates whether running instances should be terminated when the EC2 Fleet expires. Defaults to None.
        type_(str, optional): The fleet type. The default value is maintain.    maintain - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.    request - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.    instant - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.   For more information, see EC2 Fleet request types in the Amazon EC2 User Guide. Defaults to None.
        valid_from(str, optional): The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately. Defaults to None.
        valid_until(str, optional): The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it. Defaults to None.
        replace_unhealthy_instances(bool, optional): Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type maintain. For more information, see EC2 Fleet health checks in the Amazon EC2 User Guide. Defaults to None.
        tag_specifications(List, optional): The key-value pair for tagging the EC2 Fleet request on creation. For more information, see Tagging your resources. If the fleet type is instant, specify a resource type of fleet to tag the fleet or instance to tag the instances at launch. If the fleet type is maintain or request, specify a resource type of fleet to tag the fleet. You cannot specify a resource type of instance. To tag instances at launch, specify the tags in a launch template. Defaults to None.
        context(str, optional): Reserved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fleet.init.create(
                ctx, launch_template_configs=value, target_capacity_specification=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fleet.init.create launch_template_configs=value, target_capacity_specification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_fleet",
        op_kwargs={
            "DryRun": dry_run,
            "ClientToken": client_token,
            "SpotOptions": spot_options,
            "OnDemandOptions": on_demand_options,
            "ExcessCapacityTerminationPolicy": excess_capacity_termination_policy,
            "LaunchTemplateConfigs": launch_template_configs,
            "TargetCapacitySpecification": target_capacity_specification,
            "TerminateInstancesWithExpiration": terminate_instances_with_expiration,
            "Type": type_,
            "ValidFrom": valid_from,
            "ValidUntil": valid_until,
            "ReplaceUnhealthyInstances": replace_unhealthy_instances,
            "TagSpecifications": tag_specifications,
            "Context": context,
        },
    )


async def delete_multiple(
    hub, ctx, fleet_ids: List, terminate_instances: bool, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified EC2 Fleet. After you delete an EC2 Fleet, it launches no new instances. You must specify whether a deleted EC2 Fleet should also terminate its instances. If you choose to terminate the instances, the EC2 Fleet enters the deleted_terminating state. Otherwise, the EC2 Fleet enters the deleted_running state, and the instances continue to run until they are interrupted or you terminate them manually. For instant fleets, EC2 Fleet must terminate the instances when the fleet is deleted. A deleted instant fleet with running instances is not supported.  Restrictions    You can delete up to 25 instant fleets in a single request. If you exceed this number, no instant fleets are deleted and an error is returned. There is no restriction on the number of fleets of type maintain or request that can be deleted in a single request.   Up to 1000 instances can be terminated in a single request to delete instant fleets.   For more information, see Deleting an EC2 Fleet in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        fleet_ids(List): The IDs of the EC2 Fleets.
        terminate_instances(bool): Indicates whether to terminate the instances when the EC2 Fleet is deleted. The default is to terminate the instances. To let the instances continue to run after the EC2 Fleet is deleted, specify NoTerminateInstances. Supported only for fleets of type maintain and request. For instant fleets, you cannot specify NoTerminateInstances. A deleted instant fleet with running instances is not supported.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fleet.init.delete_multiple(
                ctx, fleet_ids=value, terminate_instances=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fleet.init.delete_multiple fleet_ids=value, terminate_instances=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_fleets",
        op_kwargs={
            "DryRun": dry_run,
            "FleetIds": fleet_ids,
            "TerminateInstances": terminate_instances,
        },
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    max_results: int = None,
    next_token: str = None,
    fleet_ids: List = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified EC2 Fleets or all of your EC2 Fleets. For more information, see Monitoring your EC2 Fleet in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        fleet_ids(List, optional): The ID of the EC2 Fleets. Defaults to None.
        filters(List, optional): The filters.    activity-status - The progress of the EC2 Fleet ( error | pending-fulfillment | pending-termination | fulfilled).    excess-capacity-termination-policy - Indicates whether to terminate running instances if the target capacity is decreased below the current EC2 Fleet size (true | false).    fleet-state - The state of the EC2 Fleet (submitted | active | deleted | failed | deleted-running | deleted-terminating | modifying).    replace-unhealthy-instances - Indicates whether EC2 Fleet should replace unhealthy instances (true | false).    type - The type of request (instant | request | maintain).  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fleet.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fleet.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_fleets",
        op_kwargs={
            "DryRun": dry_run,
            "MaxResults": max_results,
            "NextToken": next_token,
            "FleetIds": fleet_ids,
            "Filters": filters,
        },
    )


async def modify(
    hub,
    ctx,
    fleet_id: str,
    dry_run: bool = None,
    excess_capacity_termination_policy: str = None,
    launch_template_configs: List = None,
    target_capacity_specification: Dict = None,
    context: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified EC2 Fleet. You can only modify an EC2 Fleet request of type maintain. While the EC2 Fleet is being modified, it is in the modifying state. To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet launches the additional Spot Instances according to the allocation strategy for the EC2 Fleet request. If the allocation strategy is lowest-price, the EC2 Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is diversified, the EC2 Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is capacity-optimized, EC2 Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To scale down your EC2 Fleet, decrease its target capacity. First, the EC2 Fleet cancels any open requests that exceed the new target capacity. You can request that the EC2 Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is lowest-price, the EC2 Fleet terminates the instances with the highest price per unit. If the allocation strategy is capacity-optimized, the EC2 Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is diversified, the EC2 Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the EC2 Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually. If you are finished with your EC2 Fleet for now, but will use it again later, you can set the target capacity to 0.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        excess_capacity_termination_policy(str, optional): Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet. Defaults to None.
        launch_template_configs(List, optional): The launch template and overrides. Defaults to None.
        fleet_id(str): The ID of the EC2 Fleet.
        target_capacity_specification(Dict, optional): The size of the EC2 Fleet. Defaults to None.
        context(str, optional): Reserved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fleet.init.modify(ctx, fleet_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fleet.init.modify fleet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_fleet",
        op_kwargs={
            "DryRun": dry_run,
            "ExcessCapacityTerminationPolicy": excess_capacity_termination_policy,
            "LaunchTemplateConfigs": launch_template_configs,
            "FleetId": fleet_id,
            "TargetCapacitySpecification": target_capacity_specification,
            "Context": context,
        },
    )
