"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    fleet_id: str,
    start_time: str,
    dry_run: bool = None,
    event_type: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the events for the specified EC2 Fleet during the specified time. EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event. EC2 Fleet events are available for 48 hours. For more information, see Monitoring your EC2 Fleet in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        event_type(str, optional): The type of events to describe. By default, all events are described. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        fleet_id(str): The ID of the EC2 Fleet.
        start_time(str): The start date and time for the events, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.fleet.history.describe(
                ctx, fleet_id=value, start_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.fleet.history.describe fleet_id=value, start_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_fleet_history",
        op_kwargs={
            "DryRun": dry_run,
            "EventType": event_type,
            "MaxResults": max_results,
            "NextToken": next_token,
            "FleetId": fleet_id,
            "StartTime": start_time,
        },
    )
