"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, export_task_id: str) -> None:
    r"""
    **Autogenerated function**

    Cancels an active export task. The request removes all artifacts of the export, including any partially-created Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the command fails and returns an error.

    Args:
        export_task_id(str): The ID of the export task. This is the ID returned by CreateInstanceExportTask.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.export.task.cancel(ctx, export_task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.export.task.cancel export_task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="cancel_export_task",
        op_kwargs={"ExportTaskId": export_task_id},
    )


async def describe_all(
    hub, ctx, export_task_ids: List = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified export instance tasks or all of your export instance tasks.

    Args:
        export_task_ids(List, optional): The export task IDs. Defaults to None.
        filters(List, optional): the filters for the export tasks. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.export.task.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.export.task.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_export_tasks",
        op_kwargs={"ExportTaskIds": export_task_ids, "Filters": filters},
    )
