"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, certificate_arn: str = None, role_arn: str = None, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more information, see Certificate Manager for Nitro Enclaves in the Amazon Web Services Nitro Enclaves User Guide. When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted private key are placed in an Amazon S3 bucket that only the associated IAM role can access. The private key of the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key policy. To enable the IAM role to access the Amazon S3 object, you must grant it permission to call s3:GetObject on the Amazon S3 bucket returned by the command. To enable the IAM role to access the KMS key, you must grant it permission to call kms:Decrypt on the KMS key returned by the command. For more information, see  Grant the role permission to access the certificate and encryption key in the Amazon Web Services Nitro Enclaves User Guide.

    Args:
        certificate_arn(str, optional): The ARN of the ACM certificate with which to associate the IAM role. Defaults to None.
        role_arn(str, optional): The ARN of the IAM role to associate with the ACM certificate. You can associate up to 16 IAM roles with an ACM certificate. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.enclave_certificate_iam_role.associate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.enclave_certificate_iam_role.associate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_enclave_certificate_iam_role",
        op_kwargs={
            "CertificateArn": certificate_arn,
            "RoleArn": role_arn,
            "DryRun": dry_run,
        },
    )


async def disassociate(
    hub, ctx, certificate_arn: str = None, role_arn: str = None, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates an IAM role from an Certificate Manager (ACM) certificate. Disassociating an IAM role from an ACM certificate removes the Amazon S3 object that contains the certificate, certificate chain, and encrypted private key from the Amazon S3 bucket. It also revokes the IAM role's permission to use the KMS key used to encrypt the private key. This effectively revokes the role's permission to use the certificate.

    Args:
        certificate_arn(str, optional): The ARN of the ACM certificate from which to disassociate the IAM role. Defaults to None.
        role_arn(str, optional): The ARN of the IAM role to disassociate. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.enclave_certificate_iam_role.disassociate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.enclave_certificate_iam_role.disassociate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_enclave_certificate_iam_role",
        op_kwargs={
            "CertificateArn": certificate_arn,
            "RoleArn": role_arn,
            "DryRun": dry_run,
        },
    )
