"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    vpc_id: str,
    client_token: str = None,
    dry_run: bool = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6 connection with your instance.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_id(str): The ID of the VPC for which to create the egress-only internet gateway.
        tag_specifications(List, optional): The tags to assign to the egress-only internet gateway. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.egress_only_internet_gateway.create(ctx, vpc_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.egress_only_internet_gateway.create vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_egress_only_internet_gateway",
        op_kwargs={
            "ClientToken": client_token,
            "DryRun": dry_run,
            "VpcId": vpc_id,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete(
    hub, ctx, egress_only_internet_gateway_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an egress-only internet gateway.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        egress_only_internet_gateway_id(str): The ID of the egress-only internet gateway.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.egress_only_internet_gateway.delete(
                ctx, egress_only_internet_gateway_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.egress_only_internet_gateway.delete egress_only_internet_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_egress_only_internet_gateway",
        op_kwargs={
            "DryRun": dry_run,
            "EgressOnlyInternetGatewayId": egress_only_internet_gateway_id,
        },
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    egress_only_internet_gateway_ids: List = None,
    max_results: int = None,
    next_token: str = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your egress-only internet gateways.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        egress_only_internet_gateway_ids(List, optional): One or more egress-only internet gateway IDs. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        filters(List, optional): One or more filters.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.egress_only_internet_gateway.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.egress_only_internet_gateway.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_egress_only_internet_gateways",
        op_kwargs={
            "DryRun": dry_run,
            "EgressOnlyInternetGatewayIds": egress_only_internet_gateway_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
        },
    )
