"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Disables EBS encryption by default for your account in the current Region. After you disable encryption by default, you can still create encrypted volumes by enabling encryption when you create each volume. Disabling encryption by default does not change the encryption status of your existing volumes. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.ebs.encryption_by_default.disable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.ebs.encryption_by_default.disable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disable_ebs_encryption_by_default",
        op_kwargs={"DryRun": dry_run},
    )


async def enable(hub, ctx, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Enables EBS encryption by default for your account in the current Region. After you enable encryption by default, the EBS volumes that you create are always encrypted, either using the default KMS key or the KMS key that you specified when you created each volume. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide. You can specify the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId. Enabling encryption by default has no effect on the encryption status of your existing volumes. After you enable encryption by default, you can no longer launch instances using instance types that do not support encryption. For more information, see Supported instance types.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.ebs.encryption_by_default.enable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.ebs.encryption_by_default.enable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="enable_ebs_encryption_by_default",
        op_kwargs={"DryRun": dry_run},
    )


async def get(hub, ctx, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes whether EBS encryption by default is enabled for your account in the current Region. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.ebs.encryption_by_default.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.ebs.encryption_by_default.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_ebs_encryption_by_default",
        op_kwargs={"DryRun": dry_run},
    )
