"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "default_kms_key_id"


async def get(hub, ctx, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the default KMS key for EBS encryption by default for your account in this Region. You can change the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.ebs.default_kms_key_id_.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.ebs.default_kms_key_id.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_ebs_default_kms_key_id",
        op_kwargs={"DryRun": dry_run},
    )


async def modify(hub, ctx, kms_key_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Changes the default KMS key for EBS encryption by default for your account in this Region. Amazon Web Services creates a unique Amazon Web Services managed KMS key in each Region for use with encryption by default. If you change the default KMS key to a symmetric customer managed KMS key, it is used instead of the Amazon Web Services managed KMS key. To reset the default KMS key to the Amazon Web Services managed KMS key for EBS, use ResetEbsDefaultKmsKeyId. Amazon EBS does not support asymmetric KMS keys. If you delete or disable the customer managed KMS key that you specified for use with encryption by default, your instances will fail to launch. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.

    Args:
        kms_key_id(str): The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key for Amazon EBS is used. If KmsKeyId is specified, the encrypted state must be true. You can specify the KMS key using any of the following:   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias. For example, alias/ExampleAlias.   Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.   Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails. Amazon EBS does not support asymmetric KMS keys.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.ebs.default_kms_key_id_.modify(ctx, kms_key_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.ebs.default_kms_key_id.modify kms_key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_ebs_default_kms_key_id",
        op_kwargs={"KmsKeyId": kms_key_id, "DryRun": dry_run},
    )


async def reset(hub, ctx, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Resets the default KMS key for EBS encryption for your account in this Region to the Amazon Web Services managed KMS key for EBS. After resetting the default KMS key to the Amazon Web Services managed KMS key, you can continue to encrypt by a customer managed KMS key by specifying it when you create the volume. For more information, see Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.ebs.default_kms_key_id_.reset(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.ebs.default_kms_key_id.reset
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reset_ebs_default_kms_key_id",
        op_kwargs={"DryRun": dry_run},
    )
