"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, availability_zone: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a default subnet with a size /20 IPv4 CIDR block in the specified Availability Zone in your default VPC. You can have only one default subnet per Availability Zone. For more information, see Creating a default subnet in the Amazon Virtual Private Cloud User Guide.

    Args:
        availability_zone(str): The Availability Zone in which to create the default subnet.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.default.subnet.create(ctx, availability_zone=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.default.subnet.create availability_zone=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_default_subnet",
        op_kwargs={"AvailabilityZone": availability_zone, "DryRun": dry_run},
    )
