"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    bgp_asn: int,
    type_: str,
    public_ip: str = None,
    certificate_arn: str = None,
    tag_specifications: List = None,
    device_name: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides information to AWS about your VPN customer gateway device. The customer gateway is the appliance at your end of the VPN connection. (The device on the AWS side of the VPN connection is the virtual private gateway.) You must provide the internet-routable IP address of the customer gateway's external interface. The IP address must be static and can be behind a device performing network address translation (NAT). For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use a private ASN (in the 64512 - 65534 range).  Amazon EC2 supports all 4-byte ASN numbers in the range of 1 - 2147483647, with the exception of the following:   7224 - reserved in the us-east-1 Region   9059 - reserved in the eu-west-1 Region   17943 - reserved in the ap-southeast-1 Region   10124 - reserved in the ap-northeast-1 Region    For more information, see AWS Site-to-Site VPN in the AWS Site-to-Site VPN User Guide.  To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device name for each customer gateway. Identical requests return information about the existing customer gateway and do not create new customer gateways.

    Args:
        bgp_asn(int): For devices that support BGP, the customer gateway's BGP ASN. Default: 65000.
        public_ip(str, optional): The Internet-routable IP address for the customer gateway's outside interface. The address must be static. Defaults to None.
        certificate_arn(str, optional): The Amazon Resource Name (ARN) for the customer gateway certificate. Defaults to None.
        type_(str): The type of VPN connection that this customer gateway supports (ipsec.1).
        tag_specifications(List, optional): The tags to apply to the customer gateway. Defaults to None.
        device_name(str, optional): A name for the customer gateway device. Length Constraints: Up to 255 characters. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.customer_gateway.create(ctx, bgp_asn=value, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.customer_gateway.create bgp_asn=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_customer_gateway",
        op_kwargs={
            "BgpAsn": bgp_asn,
            "PublicIp": public_ip,
            "CertificateArn": certificate_arn,
            "Type": type_,
            "TagSpecifications": tag_specifications,
            "DeviceName": device_name,
            "DryRun": dry_run,
        },
    )


async def delete(hub, ctx, customer_gateway_id: str, dry_run: bool = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer gateway.

    Args:
        customer_gateway_id(str): The ID of the customer gateway.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.customer_gateway.delete(ctx, customer_gateway_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.customer_gateway.delete customer_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_customer_gateway",
        op_kwargs={"CustomerGatewayId": customer_gateway_id, "DryRun": dry_run},
    )


async def describe_all(
    hub,
    ctx,
    customer_gateway_ids: List = None,
    filters: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your VPN customer gateways. For more information, see AWS Site-to-Site VPN in the AWS Site-to-Site VPN User Guide.

    Args:
        customer_gateway_ids(List, optional): One or more customer gateway IDs. Default: Describes all your customer gateways. Defaults to None.
        filters(List, optional): One or more filters.    bgp-asn - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).    customer-gateway-id - The ID of the customer gateway.    ip-address - The IP address of the customer gateway's Internet-routable external interface.    state - The state of the customer gateway (pending | available | deleting | deleted).    type - The type of customer gateway. Currently, the only supported type is ipsec.1.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.customer_gateway.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.customer_gateway.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_customer_gateways",
        op_kwargs={
            "CustomerGatewayIds": customer_gateway_ids,
            "Filters": filters,
            "DryRun": dry_run,
        },
    )
