"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(
    hub, ctx, conversion_task_id: str, dry_run: bool = None, reason_message: str = None
) -> None:
    r"""
    **Autogenerated function**

    Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is in the process of transferring the final disk image, the command fails and returns an exception. For more information, see Importing a Virtual Machine Using the Amazon EC2 CLI.

    Args:
        conversion_task_id(str): The ID of the conversion task.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        reason_message(str, optional): The reason for canceling the conversion task. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.conversion_task.cancel(ctx, conversion_task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.conversion_task.cancel conversion_task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="cancel_conversion_task",
        op_kwargs={
            "ConversionTaskId": conversion_task_id,
            "DryRun": dry_run,
            "ReasonMessage": reason_message,
        },
    )


async def describe_all(
    hub, ctx, conversion_task_ids: List = None, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified conversion tasks or all your conversion tasks. For more information, see the VM Import/Export User Guide. For information about the import manifest referenced by this API action, see VM Import Manifest.

    Args:
        conversion_task_ids(List, optional): The conversion task IDs. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.conversion_task.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.conversion_task.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_conversion_tasks",
        op_kwargs={"ConversionTaskIds": conversion_task_ids, "DryRun": dry_run},
    )
