"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, instance_id: str, dry_run: bool = None, wake_up: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve a JPG-format screenshot of a running instance to help with troubleshooting. The returned content is Base64-encoded.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_id(str): The ID of the instance.
        wake_up(bool, optional): When set to true, acts as keystroke input and wakes up an instance that's in standby or "sleep" mode. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.console.screenshot.get(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.console.screenshot.get instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_console_screenshot",
        op_kwargs={"DryRun": dry_run, "InstanceId": instance_id, "WakeUp": wake_up},
    )
