"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    subnet_id: str,
    client_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy. If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and change the VPC that's associated with it.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint.
        subnet_id(str): The ID of the subnet to associate with the Client VPN endpoint.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.target_network.associate(
                ctx, client_vpn_endpoint_id=value, subnet_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.target_network.associate client_vpn_endpoint_id=value, subnet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_client_vpn_target_network",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "SubnetId": subnet_id,
            "ClientToken": client_token,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    association_ids: List = None,
    max_results: int = None,
    next_token: str = None,
    filters: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the target networks associated with the specified Client VPN endpoint.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint.
        association_ids(List, optional): The IDs of the target network associations. Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.
        filters(List, optional): One or more filters. Filter names and values are case-sensitive.    association-id - The ID of the association.    target-network-id - The ID of the subnet specified as the target network.    vpc-id - The ID of the VPC in which the target network is located.  . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.target_network.describe_all(
                ctx, client_vpn_endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.target_network.describe_all client_vpn_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_client_vpn_target_networks",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "AssociationIds": association_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
            "DryRun": dry_run,
        },
    )


async def disassociate(
    hub, ctx, client_vpn_endpoint_id: str, association_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a target network from the specified Client VPN endpoint. When you disassociate the last target network from a Client VPN, the following happens:   The route that was automatically added for the VPC is deleted   All active client connections are terminated   New client connections are disallowed   The Client VPN endpoint's status changes to pending-associate

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint from which to disassociate the target network.
        association_id(str): The ID of the target network association.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.target_network.disassociate(
                ctx, client_vpn_endpoint_id=value, association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.target_network.disassociate client_vpn_endpoint_id=value, association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_client_vpn_target_network",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "AssociationId": association_id,
            "DryRun": dry_run,
        },
    )
