"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    destination_cidr_block: str,
    target_vpc_subnet_id: str,
    description: str = None,
    client_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc resources or networks.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint to which to add the route.
        destination_cidr_block(str): The IPv4 address range, in CIDR notation, of the route destination. For example:   To add a route for Internet access, enter 0.0.0.0/0    To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range   To add a route for an on-premises network, enter the AWS Site-to-Site VPN connection's IPv4 CIDR range   To add a route for the local network, enter the client CIDR range  .
        target_vpc_subnet_id(str): The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint. Alternatively, if you're adding a route for the local network, specify local.
        description(str, optional): A brief description of the route. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.route.create(
                ctx,
                client_vpn_endpoint_id=value,
                destination_cidr_block=value,
                target_vpc_subnet_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.route.create client_vpn_endpoint_id=value, destination_cidr_block=value, target_vpc_subnet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_client_vpn_route",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "DestinationCidrBlock": destination_cidr_block,
            "TargetVpcSubnetId": target_vpc_subnet_id,
            "Description": description,
            "ClientToken": client_token,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    destination_cidr_block: str,
    target_vpc_subnet_id: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the CreateClientVpnRoute action. You cannot delete routes that were automatically added when associating a subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN endpoint.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint from which the route is to be deleted.
        target_vpc_subnet_id(str, optional): The ID of the target subnet used by the route. Defaults to None.
        destination_cidr_block(str): The IPv4 address range, in CIDR notation, of the route to be deleted.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.route.delete(
                ctx, client_vpn_endpoint_id=value, destination_cidr_block=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.route.delete client_vpn_endpoint_id=value, destination_cidr_block=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_client_vpn_route",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "TargetVpcSubnetId": target_vpc_subnet_id,
            "DestinationCidrBlock": destination_cidr_block,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the routes for the specified Client VPN endpoint.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint.
        filters(List, optional): One or more filters. Filter names and values are case-sensitive.    destination-cidr - The CIDR of the route destination.    origin - How the route was associated with the Client VPN endpoint (associate | add-route).    target-subnet - The ID of the subnet through which traffic is routed.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.route.describe_all(
                ctx, client_vpn_endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.route.describe_all client_vpn_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_client_vpn_routes",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )
