"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def authorize(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    target_network_cidr: str,
    access_group_id: str = None,
    authorize_all_groups: bool = None,
    description: str = None,
    client_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules that grant access to networks. You must configure ingress authorization rules to enable clients to access resources in AWS or on-premises networks.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint.
        target_network_cidr(str): The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
        access_group_id(str, optional): The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if AuthorizeAllGroups is false or not specified. Defaults to None.
        authorize_all_groups(bool, optional): Indicates whether to grant access to all clients. Specify true to grant all clients who successfully establish a VPN connection access to the network. Must be set to true if AccessGroupId is not specified. Defaults to None.
        description(str, optional): A brief description of the authorization rule. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.ingress.authorize(
                ctx, client_vpn_endpoint_id=value, target_network_cidr=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.ingress.authorize client_vpn_endpoint_id=value, target_network_cidr=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="authorize_client_vpn_ingress",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "TargetNetworkCidr": target_network_cidr,
            "AccessGroupId": access_group_id,
            "AuthorizeAllGroups": authorize_all_groups,
            "Description": description,
            "ClientToken": client_token,
            "DryRun": dry_run,
        },
    )


async def revoke(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    target_network_cidr: str,
    access_group_id: str = None,
    revoke_all_groups: bool = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes an ingress authorization rule from a Client VPN endpoint.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint with which the authorization rule is associated.
        target_network_cidr(str): The IPv4 address range, in CIDR notation, of the network for which access is being removed.
        access_group_id(str, optional): The ID of the Active Directory group for which to revoke access. . Defaults to None.
        revoke_all_groups(bool, optional): Indicates whether access should be revoked for all clients. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.ingress.revoke(
                ctx, client_vpn_endpoint_id=value, target_network_cidr=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.ingress.revoke client_vpn_endpoint_id=value, target_network_cidr=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="revoke_client_vpn_ingress",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "TargetNetworkCidr": target_network_cidr,
            "AccessGroupId": access_group_id,
            "RevokeAllGroups": revoke_all_groups,
            "DryRun": dry_run,
        },
    )
