"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_cidr_block: str,
    server_certificate_arn: str,
    authentication_options: List,
    connection_log_options: Dict,
    dns_servers: List = None,
    transport_protocol: str = None,
    vpn_port: int = None,
    description: str = None,
    split_tunnel: bool = None,
    dry_run: bool = None,
    client_token: str = None,
    tag_specifications: List = None,
    security_group_ids: List = None,
    vpc_id: str = None,
    self_service_portal: str = None,
    client_connect_options: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.

    Args:
        client_cidr_block(str): The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
        server_certificate_arn(str): The ARN of the server certificate. For more information, see the AWS Certificate Manager User Guide.
        authentication_options(List): Information about the authentication method to be used to authenticate clients.
        connection_log_options(Dict): Information about the client connection logging options. If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:   Client connection requests   Client connection results (successful and unsuccessful)   Reasons for unsuccessful client connection requests   Client connection termination time  .
        dns_servers(List, optional): Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server. Defaults to None.
        transport_protocol(str, optional): The transport protocol to be used by the VPN session. Default value: udp . Defaults to None.
        vpn_port(int, optional): The port number to assign to the Client VPN endpoint for TCP and UDP traffic. Valid Values: 443 | 1194  Default Value: 443 . Defaults to None.
        description(str, optional): A brief description of the Client VPN endpoint. Defaults to None.
        split_tunnel(bool, optional): Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint. By default, split-tunnel on a VPN endpoint is disabled. For information about split-tunnel VPN endpoints, see Split-Tunnel AWS Client VPN Endpoint in the AWS Client VPN Administrator Guide. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the Client VPN endpoint during creation. Defaults to None.
        security_group_ids(List, optional): The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups. Defaults to None.
        vpc_id(str, optional): The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied. Defaults to None.
        self_service_portal(str, optional): Specify whether to enable the self-service portal for the Client VPN endpoint. Default Value: enabled . Defaults to None.
        client_connect_options(Dict, optional): The options for managing connection authorization for new client connections. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.endpoint.create(
                ctx,
                client_cidr_block=value,
                server_certificate_arn=value,
                authentication_options=value,
                connection_log_options=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.endpoint.create client_cidr_block=value, server_certificate_arn=value, authentication_options=value, connection_log_options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_client_vpn_endpoint",
        op_kwargs={
            "ClientCidrBlock": client_cidr_block,
            "ServerCertificateArn": server_certificate_arn,
            "AuthenticationOptions": authentication_options,
            "ConnectionLogOptions": connection_log_options,
            "DnsServers": dns_servers,
            "TransportProtocol": transport_protocol,
            "VpnPort": vpn_port,
            "Description": description,
            "SplitTunnel": split_tunnel,
            "DryRun": dry_run,
            "ClientToken": client_token,
            "TagSpecifications": tag_specifications,
            "SecurityGroupIds": security_group_ids,
            "VpcId": vpc_id,
            "SelfServicePortal": self_service_portal,
            "ClientConnectOptions": client_connect_options,
        },
    )


async def delete(hub, ctx, client_vpn_endpoint_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a Client VPN endpoint.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN to be deleted.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.endpoint.delete(
                ctx, client_vpn_endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.endpoint.delete client_vpn_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_client_vpn_endpoint",
        op_kwargs={"ClientVpnEndpointId": client_vpn_endpoint_id, "DryRun": dry_run},
    )


async def describe_all(
    hub,
    ctx,
    client_vpn_endpoint_ids: List = None,
    max_results: int = None,
    next_token: str = None,
    filters: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more Client VPN endpoints in the account.

    Args:
        client_vpn_endpoint_ids(List, optional): The ID of the Client VPN endpoint. Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.
        filters(List, optional): One or more filters. Filter names and values are case-sensitive.    endpoint-id - The ID of the Client VPN endpoint.    transport-protocol - The transport protocol (tcp | udp).  . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.endpoint.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.endpoint.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_client_vpn_endpoints",
        op_kwargs={
            "ClientVpnEndpointIds": client_vpn_endpoint_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
            "DryRun": dry_run,
        },
    )


async def modify(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    server_certificate_arn: str = None,
    connection_log_options: Dict = None,
    dns_servers: Dict = None,
    vpn_port: int = None,
    description: str = None,
    split_tunnel: bool = None,
    dry_run: bool = None,
    security_group_ids: List = None,
    vpc_id: str = None,
    self_service_portal: str = None,
    client_connect_options: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified Client VPN endpoint. Modifying the DNS server resets existing client connections.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint to modify.
        server_certificate_arn(str, optional): The ARN of the server certificate to be used. The server certificate must be provisioned in AWS Certificate Manager (ACM). Defaults to None.
        connection_log_options(Dict, optional): Information about the client connection logging options. If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:   Client connection requests   Client connection results (successful and unsuccessful)   Reasons for unsuccessful client connection requests   Client connection termination time  . Defaults to None.
        dns_servers(Dict, optional): Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up to two DNS servers. Defaults to None.
        vpn_port(int, optional): The port number to assign to the Client VPN endpoint for TCP and UDP traffic. Valid Values: 443 | 1194  Default Value: 443 . Defaults to None.
        description(str, optional): A brief description of the Client VPN endpoint. Defaults to None.
        split_tunnel(bool, optional): Indicates whether the VPN is split-tunnel. For information about split-tunnel VPN endpoints, see Split-Tunnel AWS Client VPN Endpoint in the AWS Client VPN Administrator Guide. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        security_group_ids(List, optional): The IDs of one or more security groups to apply to the target network. Defaults to None.
        vpc_id(str, optional): The ID of the VPC to associate with the Client VPN endpoint. Defaults to None.
        self_service_portal(str, optional): Specify whether to enable the self-service portal for the Client VPN endpoint. Defaults to None.
        client_connect_options(Dict, optional): The options for managing connection authorization for new client connections. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.endpoint.modify(
                ctx, client_vpn_endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.endpoint.modify client_vpn_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_client_vpn_endpoint",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "ServerCertificateArn": server_certificate_arn,
            "ConnectionLogOptions": connection_log_options,
            "DnsServers": dns_servers,
            "VpnPort": vpn_port,
            "Description": description,
            "SplitTunnel": split_tunnel,
            "DryRun": dry_run,
            "SecurityGroupIds": security_group_ids,
            "VpcId": vpc_id,
            "SelfServicePortal": self_service_portal,
            "ClientConnectOptions": client_connect_options,
        },
    )
