"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def export(hub, ctx, client_vpn_endpoint_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Downloads the contents of the Client VPN endpoint configuration file for the specified Client VPN endpoint. The Client VPN endpoint configuration file includes the Client VPN endpoint and certificate information clients need to establish a connection with the Client VPN endpoint.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.client.configuration.export(
                ctx, client_vpn_endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.client.configuration.export client_vpn_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="export_client_vpn_client_configuration",
        op_kwargs={"ClientVpnEndpointId": client_vpn_endpoint_id, "DryRun": dry_run},
    )
