"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "certificate_revocation_list"


__func_alias__ = {"import_": "import"}


async def export(hub, ctx, client_vpn_endpoint_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Downloads the client certificate revocation list for the specified Client VPN endpoint.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.client.certificate_revocation_list_.export(ctx, client_vpn_endpoint_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.client.certificate_revocation_list.export client_vpn_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="export_client_vpn_client_certificate_revocation_list",
        op_kwargs={"ClientVpnEndpointId": client_vpn_endpoint_id, "DryRun": dry_run},
    )


async def import_(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    certificate_revocation_list: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Uploads a client certificate revocation list to the specified Client VPN endpoint. Uploading a client certificate revocation list overwrites the existing client certificate revocation list. Uploading a client certificate revocation list resets existing client connections.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint to which the client certificate revocation list applies.
        certificate_revocation_list(str): The client certificate revocation list file. For more information, see Generate a Client Certificate Revocation List in the AWS Client VPN Administrator Guide.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.client.certificate_revocation_list_.import(ctx, client_vpn_endpoint_id=value, certificate_revocation_list=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.client.certificate_revocation_list.import client_vpn_endpoint_id=value, certificate_revocation_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="import_client_vpn_client_certificate_revocation_list",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "CertificateRevocationList": certificate_revocation_list,
            "DryRun": dry_run,
        },
    )
