"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    dry_run: bool = None,
    next_token: str = None,
    filters: List = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the authorization rules for a specified Client VPN endpoint.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.
        filters(List, optional): One or more filters. Filter names and values are case-sensitive.    description - The description of the authorization rule.    destination-cidr - The CIDR of the network to which the authorization rule applies.    group-id - The ID of the Active Directory group to which the authorization rule grants access.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.client_vpn.authorization_rule.describe_all(
                ctx, client_vpn_endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.client_vpn.authorization_rule.describe_all client_vpn_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_client_vpn_authorization_rules",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "DryRun": dry_run,
            "NextToken": next_token,
            "Filters": filters,
            "MaxResults": max_results,
        },
    )
