"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(
    hub, ctx, groups: List, instance_id: str, vpc_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the running state. An instance is automatically unlinked from a VPC when it's stopped - you can link it to the VPC again when you restart it. After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again. Linking your instance to a VPC is sometimes referred to as attaching your instance.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        groups(List): The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.
        instance_id(str): The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.
        vpc_id(str): The ID of a ClassicLink-enabled VPC.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.classic_link.vpc.attach(
                ctx, groups=value, instance_id=value, vpc_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.classic_link.vpc.attach groups=value, instance_id=value, vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="attach_classic_link_vpc",
        op_kwargs={
            "DryRun": dry_run,
            "Groups": groups,
            "InstanceId": instance_id,
            "VpcId": vpc_id,
        },
    )


async def detach(hub, ctx, instance_id: str, vpc_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it's stopped.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_id(str): The ID of the instance to unlink from the VPC.
        vpc_id(str): The ID of the VPC to which the instance is linked.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.classic_link.vpc.detach(
                ctx, instance_id=value, vpc_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.classic_link.vpc.detach instance_id=value, vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="detach_classic_link_vpc",
        op_kwargs={"DryRun": dry_run, "InstanceId": instance_id, "VpcId": vpc_id},
    )
