"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    vpc_id: str,
    tag_specifications: List = None,
    dry_run: bool = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a carrier gateway. For more information about carrier gateways, see Carrier gateways in the Amazon Web Services Wavelength Developer Guide.

    Args:
        vpc_id(str): The ID of the VPC to associate with the carrier gateway.
        tag_specifications(List, optional): The tags to associate with the carrier gateway. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to ensure idempotency. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.carrier_gateway.create(ctx, vpc_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.carrier_gateway.create vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_carrier_gateway",
        op_kwargs={
            "VpcId": vpc_id,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, carrier_gateway_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a carrier gateway.  If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route. For information about how to delete a route, see DeleteRoute.

    Args:
        carrier_gateway_id(str): The ID of the carrier gateway.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.carrier_gateway.delete(ctx, carrier_gateway_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.carrier_gateway.delete carrier_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_carrier_gateway",
        op_kwargs={"CarrierGatewayId": carrier_gateway_id, "DryRun": dry_run},
    )


async def describe_all(
    hub,
    ctx,
    carrier_gateway_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your carrier gateways.

    Args:
        carrier_gateway_ids(List, optional): One or more carrier gateway IDs. Defaults to None.
        filters(List, optional): One or more filters.    carrier-gateway-id - The ID of the carrier gateway.    state - The state of the carrier gateway (pending | failed | available | deleting | deleted).    owner-id - The Amazon Web Services account ID of the owner of the carrier gateway.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    vpc-id - The ID of the VPC associated with the carrier gateway.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.carrier_gateway.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.carrier_gateway.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_carrier_gateways",
        op_kwargs={
            "CarrierGatewayIds": carrier_gateway_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )
