"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, capacity_reservation_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation's state to cancelled. Instances running in the reserved capacity continue running until you stop them. Stopped instances that target the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching attributes and sufficient capacity.

    Args:
        capacity_reservation_id(str): The ID of the Capacity Reservation to be cancelled.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.capacity_reservation.init.cancel(
                ctx, capacity_reservation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.capacity_reservation.init.cancel capacity_reservation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="cancel_capacity_reservation",
        op_kwargs={"CapacityReservationId": capacity_reservation_id, "DryRun": dry_run},
    )


async def create(
    hub,
    ctx,
    instance_type: str,
    instance_platform: str,
    instance_count: int,
    client_token: str = None,
    availability_zone: str = None,
    availability_zone_id: str = None,
    tenancy: str = None,
    ebs_optimized: bool = None,
    ephemeral_storage: bool = None,
    end_date: str = None,
    end_date_type: str = None,
    instance_match_criteria: str = None,
    tag_specifications: List = None,
    dry_run: bool = None,
    outpost_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Capacity Reservation with the specified attributes. Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see Capacity Reservations in the Amazon EC2 User Guide. Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is flexible across instance types and sizes, try to create a Capacity Reservation with different instance attributes. Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the required instance type and try again. For more information about increasing your instance limits, see Amazon EC2 Service Quotas in the Amazon EC2 User Guide.

    Args:
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see Ensure Idempotency. Defaults to None.
        instance_type(str): The instance type for which to reserve capacity. For more information, see Instance types in the Amazon EC2 User Guide.
        instance_platform(str): The type of operating system for which to reserve capacity.
        availability_zone(str, optional): The Availability Zone in which to create the Capacity Reservation. Defaults to None.
        availability_zone_id(str, optional): The ID of the Availability Zone in which to create the Capacity Reservation. Defaults to None.
        tenancy(str, optional): Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:    default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.    dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.  . Defaults to None.
        instance_count(int): The number of instances for which to reserve capacity.
        ebs_optimized(bool, optional): Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance. Defaults to None.
        ephemeral_storage(bool, optional): Indicates whether the Capacity Reservation supports instances with temporary, block-level storage. Defaults to None.
        end_date(str, optional): The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time. You must provide an EndDate value if EndDateType is limited. Omit EndDate if EndDateType is unlimited. If the EndDateType is limited, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019. Defaults to None.
        end_date_type(str, optional): Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:    unlimited - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an EndDate if the EndDateType is unlimited.    limited - The Capacity Reservation expires automatically at a specified date and time. You must provide an EndDate value if the EndDateType value is limited.  . Defaults to None.
        instance_match_criteria(str, optional): Indicates the type of instance launches that the Capacity Reservation accepts. The options include:    open - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.    targeted - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.    Default: open . Defaults to None.
        tag_specifications(List, optional): The tags to apply to the Capacity Reservation during launch. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        outpost_arn(str, optional): The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.capacity_reservation.init.create(
                ctx, instance_type=value, instance_platform=value, instance_count=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.capacity_reservation.init.create instance_type=value, instance_platform=value, instance_count=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_capacity_reservation",
        op_kwargs={
            "ClientToken": client_token,
            "InstanceType": instance_type,
            "InstancePlatform": instance_platform,
            "AvailabilityZone": availability_zone,
            "AvailabilityZoneId": availability_zone_id,
            "Tenancy": tenancy,
            "InstanceCount": instance_count,
            "EbsOptimized": ebs_optimized,
            "EphemeralStorage": ephemeral_storage,
            "EndDate": end_date,
            "EndDateType": end_date_type,
            "InstanceMatchCriteria": instance_match_criteria,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
            "OutpostArn": outpost_arn,
        },
    )


async def describe_all(
    hub,
    ctx,
    capacity_reservation_ids: List = None,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the Amazon Web Services Region that you're currently using.

    Args:
        capacity_reservation_ids(List, optional): The ID of the Capacity Reservation. Defaults to None.
        next_token(str, optional): The token to use to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned nextToken value. This value can be between 5 and 500. If maxResults is given a larger value than 500, you receive an error. Defaults to None.
        filters(List, optional): One or more filters.    instance-type - The type of instance for which the Capacity Reservation reserves capacity.    owner-id - The ID of the Amazon Web Services account that owns the Capacity Reservation.    availability-zone-id - The Availability Zone ID of the Capacity Reservation.    instance-platform - The type of operating system for which the Capacity Reservation reserves capacity.    availability-zone - The Availability Zone ID of the Capacity Reservation.    tenancy - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:    default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.    dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.      outpost-arn - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.    state - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:    active- The Capacity Reservation is active and the capacity is available for your use.    expired - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.    cancelled - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.    pending - The Capacity Reservation request was successful but the capacity provisioning is still pending.    failed - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.      start-date - The date and time at which the Capacity Reservation was started.    end-date - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.    end-date-type - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:    unlimited - The Capacity Reservation remains active until you explicitly cancel it.    limited - The Capacity Reservation expires automatically at a specified date and time.      instance-match-criteria - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:    open - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.    targeted - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.    . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.capacity_reservation.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.capacity_reservation.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_capacity_reservations",
        op_kwargs={
            "CapacityReservationIds": capacity_reservation_ids,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
            "DryRun": dry_run,
        },
    )


async def modify(
    hub,
    ctx,
    capacity_reservation_id: str,
    instance_count: int = None,
    end_date: str = None,
    end_date_type: str = None,
    accept: bool = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a Capacity Reservation's capacity and the conditions under which it is to be released. You cannot change a Capacity Reservation's instance type, EBS optimization, instance store settings, platform, Availability Zone, or instance eligibility. If you need to modify any of these attributes, we recommend that you cancel the Capacity Reservation, and then create a new one with the required attributes.

    Args:
        capacity_reservation_id(str): The ID of the Capacity Reservation.
        instance_count(int, optional): The number of instances for which to reserve capacity. Defaults to None.
        end_date(str, optional): The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time. The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019. You must provide an EndDate value if EndDateType is limited. Omit EndDate if EndDateType is unlimited. Defaults to None.
        end_date_type(str, optional): Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:    unlimited - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an EndDate value if EndDateType is unlimited.    limited - The Capacity Reservation expires automatically at a specified date and time. You must provide an EndDate value if EndDateType is limited.  . Defaults to None.
        accept(bool, optional): Reserved. Capacity Reservations you have created are accepted by default. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.capacity_reservation.init.modify(
                ctx, capacity_reservation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.capacity_reservation.init.modify capacity_reservation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_capacity_reservation",
        op_kwargs={
            "CapacityReservationId": capacity_reservation_id,
            "InstanceCount": instance_count,
            "EndDate": end_date,
            "EndDateType": end_date_type,
            "Accept": accept,
            "DryRun": dry_run,
        },
    )
