"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def advertise(hub, ctx, cidr: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP). You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time. We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and start advertising it through Amazon Web Services. It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because of BGP propagation delays. To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.

    Args:
        cidr(str): The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.byoip_cidr.advertise(ctx, cidr=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.byoip_cidr.advertise cidr=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="advertise_byoip_cidr",
        op_kwargs={"Cidr": cidr, "DryRun": dry_run},
    )


async def deprovision(hub, ctx, cidr: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Releases the specified address range that you provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool. Before you can release an address range, you must stop advertising it using WithdrawByoipCidr and you must not have any IP addresses allocated from its address range.

    Args:
        cidr(str): The address range, in CIDR notation. The prefix must be the same prefix that you specified when you provisioned the address range.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.byoip_cidr.deprovision(ctx, cidr=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.byoip_cidr.deprovision cidr=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="deprovision_byoip_cidr",
        op_kwargs={"Cidr": cidr, "DryRun": dry_run},
    )


async def describe_all(
    hub, ctx, max_results: int, dry_run: bool = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the IP address ranges that were specified in calls to ProvisionByoipCidr. To describe the address pools that were created when you provisioned the address ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        max_results(int): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.byoip_cidr.describe_all(ctx, max_results=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.byoip_cidr.describe_all max_results=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_byoip_cidrs",
        op_kwargs={
            "DryRun": dry_run,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def provision(
    hub,
    ctx,
    cidr: str,
    cidr_authorization_context: Dict = None,
    publicly_advertisable: bool = None,
    description: str = None,
    dry_run: bool = None,
    pool_tag_specifications: List = None,
    multi_region: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provisions an IPv4 or IPv6 address range for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using AdvertiseByoipCidr. Amazon Web Services verifies that you own the address range and are authorized to advertise it. You must ensure that the address range is registered to you and that you created an RPKI ROA to authorize Amazon ASNs 16509 and 14618 to advertise the address range. For more information, see Bring your own IP addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide. Provisioning an address range is an asynchronous operation, so the call returns immediately, but the address range is not ready to use until its status changes from pending-provision to provisioned. To monitor the status of an address range, use DescribeByoipCidrs. To allocate an Elastic IP address from your IPv4 address pool, use AllocateAddress with either the specific address from the address pool or the ID of the address pool.

    Args:
        cidr(str): The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can specify is /24. The most specific IPv6 prefix you can specify is /56. The address range cannot overlap with another address range that you've brought to this or another Region.
        cidr_authorization_context(Dict, optional): A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. Defaults to None.
        publicly_advertisable(bool, optional): (IPv6 only) Indicate whether the address range will be publicly advertised to the internet. Default: true. Defaults to None.
        description(str, optional): A description for the address range and the address pool. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        pool_tag_specifications(List, optional): The tags to apply to the address pool. Defaults to None.
        multi_region(bool, optional): Reserved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.byoip_cidr.provision(ctx, cidr=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.byoip_cidr.provision cidr=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="provision_byoip_cidr",
        op_kwargs={
            "Cidr": cidr,
            "CidrAuthorizationContext": cidr_authorization_context,
            "PubliclyAdvertisable": publicly_advertisable,
            "Description": description,
            "DryRun": dry_run,
            "PoolTagSpecifications": pool_tag_specifications,
            "MultiRegion": multi_region,
        },
    )


async def withdraw(hub, ctx, cidr: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time. It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because of BGP propagation delays.

    Args:
        cidr(str): The address range, in CIDR notation.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.byoip_cidr.withdraw(ctx, cidr=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.byoip_cidr.withdraw cidr=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="withdraw_byoip_cidr",
        op_kwargs={"Cidr": cidr, "DryRun": dry_run},
    )
