"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, bundle_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a bundling operation for an instance store-backed Windows instance.

    Args:
        bundle_id(str): The ID of the bundle task.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.bundle_task.cancel(ctx, bundle_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.bundle_task.cancel bundle_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="cancel_bundle_task",
        op_kwargs={"BundleId": bundle_id, "DryRun": dry_run},
    )


async def describe_all(
    hub, ctx, bundle_ids: List = None, filters: List = None, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified bundle tasks or all of your bundle tasks.  Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can still register an AMI from it. Just use RegisterImage with the Amazon S3 bucket name and image manifest name you provided to the bundle task.

    Args:
        bundle_ids(List, optional): The bundle task IDs. Default: Describes all your bundle tasks. Defaults to None.
        filters(List, optional): The filters.    bundle-id - The ID of the bundle task.    error-code - If the task failed, the error code returned.    error-message - If the task failed, the error message returned.    instance-id - The ID of the instance.    progress - The level of task completion, as a percentage (for example, 20%).    s3-bucket - The Amazon S3 bucket to store the AMI.    s3-prefix - The beginning of the AMI name.    start-time - The time the task started (for example, 2013-09-15T17:15:20.000Z).    state - The state of the task (pending | waiting-for-shutdown | bundling | storing | cancelling | complete | failed).    update-time - The time of the most recent update for the task.  . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.bundle_task.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.bundle_task.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_bundle_tasks",
        op_kwargs={"BundleIds": bundle_ids, "Filters": filters, "DryRun": dry_run},
    )
