"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(
    hub, ctx, group_name: str, opt_in_status: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the opt-in status of the Local Zone and Wavelength Zone group for your account. Use  DescribeAvailabilityZones to view the value for GroupName.

    Args:
        group_name(str): The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.
        opt_in_status(str): Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid value is opted-in. You must contact AWS Support to opt out of a Local Zone group, or Wavelength Zone group.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.availability_zone.group.modify(
                ctx, group_name=value, opt_in_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.availability_zone.group.modify group_name=value, opt_in_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_availability_zone_group",
        op_kwargs={
            "GroupName": group_name,
            "OptInStatus": opt_in_status,
            "DryRun": dry_run,
        },
    )
