"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, certificate_arn: str = None, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the IAM roles that are associated with the specified ACM (ACM) certificate. It also returns the name of the Amazon S3 bucket and the Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are stored, and the ARN of the KMS key that's used to encrypt the private key.

    Args:
        certificate_arn(str, optional): The ARN of the ACM certificate for which to view the associated IAM roles, encryption keys, and Amazon S3 object information. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.associated.enclave_certificate_iam_role.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.associated.enclave_certificate_iam_role.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_associated_enclave_certificate_iam_roles",
        op_kwargs={"CertificateArn": certificate_arn, "DryRun": dry_run},
    )
