"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def move(hub, ctx, public_ip: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The Elastic IP address must be allocated to your account for more than 24 hours, and it must not be associated with an instance. After the Elastic IP address is moved, it is no longer available for use in the EC2-Classic platform, unless you move it back using the RestoreAddressToClassic request. You cannot move an Elastic IP address that was originally allocated for use in the EC2-VPC platform to the EC2-Classic platform.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        public_ip(str): The Elastic IP address.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.to.vpc.move(ctx, public_ip=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.to.vpc.move public_ip=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="move_address_to_vpc",
        op_kwargs={"DryRun": dry_run, "PublicIp": public_ip},
    )
