"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def restore(hub, ctx, public_ip: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP address must not be associated with an instance or network interface.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        public_ip(str): The Elastic IP address.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.to.classic.restore(ctx, public_ip=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.to.classic.restore public_ip=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="restore_address_to_classic",
        op_kwargs={"DryRun": dry_run, "PublicIp": public_ip},
    )
