"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def allocate(
    hub,
    ctx,
    domain: str = None,
    address: str = None,
    public_ipv4_pool: str = None,
    network_border_group: str = None,
    customer_owned_ipv4_pool: str = None,
    dry_run: bool = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address pool and can be allocated to a different Amazon Web Services account. You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon Web Services resources using bring your own IP addresses (BYOIP). For more information, see Bring Your Own IP Addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide. [EC2-VPC] If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address that you released after it is allocated to another Amazon Web Services account. You cannot recover an Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in this operation. An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5 Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).

    Args:
        domain(str, optional): Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic. Default: If the Region supports EC2-Classic, the default is standard. Otherwise, the default is vpc. Defaults to None.
        address(str, optional): [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool. Defaults to None.
        public_ipv4_pool(str, optional): The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool. To specify a specific address from the address pool, use the Address parameter instead. Defaults to None.
        network_border_group(str, optional):  A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups. Use DescribeAvailabilityZones to view the network border groups.  You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 classic, you will receive an InvalidParameterCombination error. For more information, see Error Codes. . Defaults to None.
        customer_owned_ipv4_pool(str, optional): The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address pool. Alternatively, specify a specific address from the address pool. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        tag_specifications(List, optional): The tags to assign to the Elastic IP address. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.init.allocate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.init.allocate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="allocate_address",
        op_kwargs={
            "Domain": domain,
            "Address": address,
            "PublicIpv4Pool": public_ipv4_pool,
            "NetworkBorderGroup": network_border_group,
            "CustomerOwnedIpv4Pool": customer_owned_ipv4_pool,
            "DryRun": dry_run,
            "TagSpecifications": tag_specifications,
        },
    )


async def associate(
    hub,
    ctx,
    allocation_id: str = None,
    instance_id: str = None,
    public_ip: str = None,
    allow_reassociation: bool = None,
    dry_run: bool = None,
    network_interface_id: str = None,
    private_ip_address: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones) with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your account. An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different instance, it is disassociated from that instance and associated with the specified instance. If you associate an Elastic IP address with an instance that has an existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to your account. [VPC in an EC2-Classic account] If you don't specify a private IP address, the Elastic IP address is associated with the primary IP address. If the Elastic IP address is already associated with a different instance or a network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address with an instance or network interface that has an existing Elastic IP address. [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance or network interface.  You cannot associate an Elastic IP address with an interface in a different network border group.  This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error, and you may be charged for each time the Elastic IP address is remapped to the same instance. For more information, see the Elastic IP Addresses section of Amazon EC2 Pricing.

    Args:
        allocation_id(str, optional): [EC2-VPC] The allocation ID. This is required for EC2-VPC. Defaults to None.
        instance_id(str, optional): The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify an instance ID and the instance must be in the running state. Defaults to None.
        public_ip(str, optional): [EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic. Defaults to None.
        allow_reassociation(bool, optional): [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        network_interface_id(str, optional): [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. . Defaults to None.
        private_ip_address(str, optional): [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.init.associate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.init.associate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_address",
        op_kwargs={
            "AllocationId": allocation_id,
            "InstanceId": instance_id,
            "PublicIp": public_ip,
            "AllowReassociation": allow_reassociation,
            "DryRun": dry_run,
            "NetworkInterfaceId": network_interface_id,
            "PrivateIpAddress": private_ip_address,
        },
    )


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    public_ips: List = None,
    allocation_ids: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified Elastic IP addresses or all of your Elastic IP addresses. An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.

    Args:
        filters(List, optional): One or more filters. Filter names and values are case-sensitive.    allocation-id - [EC2-VPC] The allocation ID for the address.    association-id - [EC2-VPC] The association ID for the address.    domain - Indicates whether the address is for use in EC2-Classic (standard) or in a VPC (vpc).    instance-id - The ID of the instance the address is associated with, if any.    network-border-group - A unique set of Availability Zones, Local Zones, or Wavelength Zones from where Amazon Web Services advertises IP addresses.     network-interface-id - [EC2-VPC] The ID of the network interface that the address is associated with, if any.    network-interface-owner-id - The Amazon Web Services account ID of the owner.    private-ip-address - [EC2-VPC] The private IP address associated with the Elastic IP address.    public-ip - The Elastic IP address, or the carrier IP address.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        public_ips(List, optional): One or more Elastic IP addresses. Default: Describes all your Elastic IP addresses. Defaults to None.
        allocation_ids(List, optional): [EC2-VPC] Information about the allocation IDs. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_addresses",
        op_kwargs={
            "Filters": filters,
            "PublicIps": public_ips,
            "AllocationIds": allocation_ids,
            "DryRun": dry_run,
        },
    )


async def disassociate(
    hub, ctx, association_id: str = None, public_ip: str = None, dry_run: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Disassociates an Elastic IP address from the instance or network interface it's associated with. An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide. This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.

    Args:
        association_id(str, optional): [EC2-VPC] The association ID. Required for EC2-VPC. Defaults to None.
        public_ip(str, optional): [EC2-Classic] The Elastic IP address. Required for EC2-Classic. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.init.disassociate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.init.disassociate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_address",
        op_kwargs={
            "AssociationId": association_id,
            "PublicIp": public_ip,
            "DryRun": dry_run,
        },
    )


async def release(
    hub,
    ctx,
    allocation_id: str = None,
    public_ip: str = None,
    network_border_group: str = None,
    dry_run: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Releases the specified Elastic IP address. [EC2-Classic, default VPC] Releasing an Elastic IP address automatically disassociates it from any instance that it's associated with. To disassociate an Elastic IP address without releasing it, use DisassociateAddress. [Nondefault VPC] You must use DisassociateAddress to disassociate the Elastic IP address before you can release it. Otherwise, Amazon EC2 returns an error (InvalidIPAddress.InUse). After releasing an Elastic IP address, it is released to the IP address pool. Be sure to update your DNS records and any servers or devices that communicate with the address. If you attempt to release an Elastic IP address that you already released, you'll get an AuthFailure error if the address is already allocated to another Amazon Web Services account. [EC2-VPC] After you release an Elastic IP address for use in a VPC, you might be able to recover it. For more information, see AllocateAddress.

    Args:
        allocation_id(str, optional): [EC2-VPC] The allocation ID. Required for EC2-VPC. Defaults to None.
        public_ip(str, optional): [EC2-Classic] The Elastic IP address. Required for EC2-Classic. Defaults to None.
        network_border_group(str, optional): The set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses. If you provide an incorrect network border group, you will receive an InvalidAddress.NotFound error. For more information, see Error Codes.  You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 classic, you will receive an InvalidParameterCombination error. For more information, see Error Codes. . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.init.release(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.init.release
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="release_address",
        op_kwargs={
            "AllocationId": allocation_id,
            "PublicIp": public_ip,
            "NetworkBorderGroup": network_border_group,
            "DryRun": dry_run,
        },
    )
