"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    allocation_ids: List = None,
    attribute: str = None,
    next_token: str = None,
    max_results: int = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the attributes of the specified Elastic IP addresses. For requirements, see Using reverse DNS for email applications.

    Args:
        allocation_ids(List, optional): [EC2-VPC] The allocation IDs. Defaults to None.
        attribute(str, optional): The attribute of the IP address. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.attribute.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.attribute.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_addresses_attribute",
        op_kwargs={
            "AllocationIds": allocation_ids,
            "Attribute": attribute,
            "NextToken": next_token,
            "MaxResults": max_results,
            "DryRun": dry_run,
        },
    )


async def modify(
    hub, ctx, allocation_id: str, domain_name: str = None, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies an attribute of the specified Elastic IP address. For requirements, see Using reverse DNS for email applications.

    Args:
        allocation_id(str): [EC2-VPC] The allocation ID.
        domain_name(str, optional): The domain name to modify for the IP address. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.attribute.modify(ctx, allocation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.attribute.modify allocation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_address_attribute",
        op_kwargs={
            "AllocationId": allocation_id,
            "DomainName": domain_name,
            "DryRun": dry_run,
        },
    )


async def reset(
    hub, ctx, allocation_id: str, attribute: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Resets the attribute of the specified IP address. For requirements, see Using reverse DNS for email applications.

    Args:
        allocation_id(str): [EC2-VPC] The allocation ID.
        attribute(str): The attribute of the IP address.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.address.attribute.reset(
                ctx, allocation_id=value, attribute=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.address.attribute.reset allocation_id=value, attribute=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reset_address_attribute",
        op_kwargs={
            "AllocationId": allocation_id,
            "Attribute": attribute,
            "DryRun": dry_run,
        },
    )
