"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def complete(
    hub,
    ctx,
    snapshot_id: str,
    changed_blocks_count: int,
    checksum: str = None,
    checksum_algorithm: str = None,
    checksum_aggregation_method: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Seals and completes the snapshot after all of the required blocks of data have been written to it. Completing the snapshot changes the status to completed. You cannot write new blocks to a snapshot after it has been completed.

    Args:
        snapshot_id(str): The ID of the snapshot.
        changed_blocks_count(int): The number of blocks that were written to the snapshot.
        checksum(str, optional): An aggregated Base-64 SHA256 checksum based on the checksums of each written block. To generate the aggregated checksum using the linear aggregation method, arrange the checksums for each written block in ascending order of their block index, concatenate them to form a single string, and then generate the checksum on the entire string using the SHA256 algorithm. Defaults to None.
        checksum_algorithm(str, optional): The algorithm used to generate the checksum. Currently, the only supported algorithm is SHA256. Defaults to None.
        checksum_aggregation_method(str, optional): The aggregation method used to generate the checksum. Currently, the only supported aggregation method is LINEAR. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ebs.snapshot.init.complete(
                ctx, snapshot_id=value, changed_blocks_count=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ebs.snapshot.init.complete snapshot_id=value, changed_blocks_count=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ebs",
        operation="complete_snapshot",
        op_kwargs={
            "SnapshotId": snapshot_id,
            "ChangedBlocksCount": changed_blocks_count,
            "Checksum": checksum,
            "ChecksumAlgorithm": checksum_algorithm,
            "ChecksumAggregationMethod": checksum_aggregation_method,
        },
    )


async def start(
    hub,
    ctx,
    volume_size: int,
    parent_snapshot_id: str = None,
    tags: List = None,
    description: str = None,
    client_token: str = None,
    encrypted: bool = None,
    kms_key_arn: str = None,
    timeout: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon EBS snapshot. The new snapshot enters the pending state after the request completes.  After creating the snapshot, use  PutSnapshotBlock to write blocks of data to the snapshot.

    Args:
        volume_size(int): The size of the volume, in GiB. The maximum size is 16384 GiB (16 TiB).
        parent_snapshot_id(str, optional): The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an on-premises volume, omit this parameter. If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent snapshot. You must first create an encrypted copy of the parent snapshot using CopySnapshot. Defaults to None.
        tags(List, optional): The tags to apply to the snapshot. Defaults to None.
        description(str, optional): A description for the snapshot. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully. The subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you do not specify a client token, one is automatically generated by the AWS SDK. For more information, see  Idempotency for StartSnapshot API in the Amazon Elastic Compute Cloud User Guide. Defaults to None.
        encrypted(bool, optional): Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify true. To create an unencrypted snapshot, omit this parameter. If you specify a value for ParentSnapshotId, omit this parameter. If you specify true, the snapshot is encrypted using the CMK specified using the KmsKeyArn parameter. If no value is specified for KmsKeyArn, the default CMK for your account is used. If no default CMK has been specified for your account, the AWS managed CMK is used. To set a default CMK for your account, use  ModifyEbsDefaultKmsKeyId. If your account is enabled for encryption by default, you cannot set this parameter to false. In this case, you can omit this parameter. For more information, see  Using encryption in the Amazon Elastic Compute Cloud User Guide. Defaults to None.
        kms_key_arn(str, optional): The Amazon Resource Name (ARN) of the AWS Key Management Service (AWS KMS) customer master key (CMK) to be used to encrypt the snapshot. If you do not specify a CMK, the default AWS managed CMK is used. If you specify a ParentSnapshotId, omit this parameter; the snapshot will be encrypted using the same CMK that was used to encrypt the parent snapshot. If Encrypted is set to true, you must specify a CMK ARN. . Defaults to None.
        timeout(int, optional): The amount of time (in minutes) after which the snapshot is automatically cancelled if:   No blocks are written to the snapshot.   The snapshot is not completed after writing the last block of data.   If no value is specified, the timeout defaults to 60 minutes. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ebs.snapshot.init.start(ctx, volume_size=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ebs.snapshot.init.start volume_size=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ebs",
        operation="start_snapshot",
        op_kwargs={
            "VolumeSize": volume_size,
            "ParentSnapshotId": parent_snapshot_id,
            "Tags": tags,
            "Description": description,
            "ClientToken": client_token,
            "Encrypted": encrypted,
            "KmsKeyArn": kms_key_arn,
            "Timeout": timeout,
        },
    )
