"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, snapshot_id: str, block_index: int, block_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the data in a block in an Amazon Elastic Block Store snapshot.

    Args:
        snapshot_id(str): The ID of the snapshot containing the block from which to get data.
        block_index(int): The block index of the block from which to get data. Obtain the BlockIndex by running the ListChangedBlocks or ListSnapshotBlocks operations.
        block_token(str): The block token of the block from which to get data. Obtain the BlockToken by running the ListChangedBlocks or ListSnapshotBlocks operations.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ebs.snapshot.block.get(
                ctx, snapshot_id=value, block_index=value, block_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ebs.snapshot.block.get snapshot_id=value, block_index=value, block_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ebs",
        operation="get_snapshot_block",
        op_kwargs={
            "SnapshotId": snapshot_id,
            "BlockIndex": block_index,
            "BlockToken": block_token,
        },
    )


async def list_all(
    hub,
    ctx,
    snapshot_id: str,
    next_token: str = None,
    max_results: int = None,
    starting_block_index: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the blocks in an Amazon Elastic Block Store snapshot.

    Args:
        snapshot_id(str): The ID of the snapshot from which to get block indexes and block tokens.
        next_token(str, optional): The token to request the next page of results. Defaults to None.
        max_results(int, optional): The number of results to return. Defaults to None.
        starting_block_index(int, optional): The block index from which the list should start. The list in the response will start from this block index or the next valid block index in the snapshot. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ebs.snapshot.block.list_all(ctx, snapshot_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ebs.snapshot.block.list_all snapshot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ebs",
        operation="list_snapshot_blocks",
        op_kwargs={
            "SnapshotId": snapshot_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "StartingBlockIndex": starting_block_index,
        },
    )


async def put(
    hub,
    ctx,
    snapshot_id: str,
    block_index: int,
    block_data: bytes,
    data_length: int,
    checksum: str,
    checksum_algorithm: str,
    progress: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Writes a block of data to a snapshot. If the specified block contains data, the existing data is overwritten. The target snapshot must be in the pending state. Data written to a snapshot must be aligned with 512-byte sectors.

    Args:
        snapshot_id(str): The ID of the snapshot.
        block_index(int): The block index of the block in which to write the data. A block index is a logical index in units of 512 KiB blocks. To identify the block index, divide the logical offset of the data in the logical volume by the block size (logical offset of data/524288). The logical offset of the data must be 512 KiB aligned.
        block_data(bytes): The data to write to the block. The block data is not signed as part of the Signature Version 4 signing process. As a result, you must generate and provide a Base64-encoded SHA256 checksum for the block data using the x-amz-Checksum header. Also, you must specify the checksum algorithm using the x-amz-Checksum-Algorithm header. The checksum that you provide is part of the Signature Version 4 signing process. It is validated against a checksum generated by Amazon EBS to ensure the validity and authenticity of the data. If the checksums do not correspond, the request fails. For more information, see  Using checksums with the EBS direct APIs in the Amazon Elastic Compute Cloud User Guide.
        data_length(int): The size of the data to write to the block, in bytes. Currently, the only supported size is 524288. Valid values: 524288 .
        progress(int, optional): The progress of the write process, as a percentage. Defaults to None.
        checksum(str): A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.
        checksum_algorithm(str): The algorithm used to generate the checksum. Currently, the only supported algorithm is SHA256.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ebs.snapshot.block.put(
                ctx,
                snapshot_id=value,
                block_index=value,
                block_data=value,
                data_length=value,
                checksum=value,
                checksum_algorithm=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ebs.snapshot.block.put snapshot_id=value, block_index=value, block_data=value, data_length=value, checksum=value, checksum_algorithm=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ebs",
        operation="put_snapshot_block",
        op_kwargs={
            "SnapshotId": snapshot_id,
            "BlockIndex": block_index,
            "BlockData": block_data,
            "DataLength": data_length,
            "Progress": progress,
            "Checksum": checksum,
            "ChecksumAlgorithm": checksum_algorithm,
        },
    )
