"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    second_snapshot_id: str,
    first_snapshot_id: str = None,
    next_token: str = None,
    max_results: int = None,
    starting_block_index: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the blocks that are different between two Amazon Elastic Block Store snapshots of the same volume/snapshot lineage.

    Args:
        first_snapshot_id(str, optional): The ID of the first snapshot to use for the comparison.  The FirstSnapshotID parameter must be specified with a SecondSnapshotId parameter; otherwise, an error occurs. . Defaults to None.
        second_snapshot_id(str): The ID of the second snapshot to use for the comparison.  The SecondSnapshotId parameter must be specified with a FirstSnapshotID parameter; otherwise, an error occurs. .
        next_token(str, optional): The token to request the next page of results. Defaults to None.
        max_results(int, optional): The number of results to return. Defaults to None.
        starting_block_index(int, optional): The block index from which the comparison should start. The list in the response will start from this block index or the next valid block index in the snapshots. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ebs.changed_block.list_all(ctx, second_snapshot_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ebs.changed_block.list_all second_snapshot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ebs",
        operation="list_changed_blocks",
        op_kwargs={
            "FirstSnapshotId": first_snapshot_id,
            "SecondSnapshotId": second_snapshot_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "StartingBlockIndex": starting_block_index,
        },
    )
