"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, stream_arn: str, limit: int = None, exclusive_start_shard_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table.  You can call DescribeStream at a maximum rate of 10 times per second.  Each shard in the stream has a SequenceNumberRange associated with it. If the SequenceNumberRange has a StartingSequenceNumber but no EndingSequenceNumber, then the shard is still open (able to receive more stream records). If both StartingSequenceNumber and EndingSequenceNumber are present, then that shard is closed and can no longer receive more data.

    Args:
        stream_arn(str): The Amazon Resource Name (ARN) for the stream.
        limit(int, optional): The maximum number of shard objects to return. The upper limit is 100. Defaults to None.
        exclusive_start_shard_id(str, optional): The shard ID of the first item that this operation will evaluate. Use the value that was returned for LastEvaluatedShardId in the previous operation. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodbstream.stream.describe(ctx, stream_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodbstream.stream.describe stream_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodbstreams",
        operation="describe_stream",
        op_kwargs={
            "StreamArn": stream_arn,
            "Limit": limit,
            "ExclusiveStartShardId": exclusive_start_shard_id,
        },
    )


async def list_all(
    hub,
    ctx,
    table_name: str = None,
    limit: int = None,
    exclusive_start_stream_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of stream ARNs associated with the current account and endpoint. If the TableName parameter is present, then ListStreams will return only the streams ARNs for that table.  You can call ListStreams at a maximum rate of 5 times per second.

    Args:
        table_name(str, optional): If this parameter is provided, then only the streams associated with this table name are returned. Defaults to None.
        limit(int, optional): The maximum number of streams to return. The upper limit is 100. Defaults to None.
        exclusive_start_stream_arn(str, optional): The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the value that was returned for LastEvaluatedStreamArn in the previous operation. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodbstream.stream.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodbstream.stream.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodbstreams",
        operation="list_streams",
        op_kwargs={
            "TableName": table_name,
            "Limit": limit,
            "ExclusiveStartStreamArn": exclusive_start_stream_arn,
        },
    )
