"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    stream_arn: str,
    shard_id: str,
    shard_iterator_type: str,
    sequence_number: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a shard iterator. A shard iterator provides information about how to retrieve the stream records from within a shard. Use the shard iterator in a subsequent GetRecords request to read the stream records from the shard.  A shard iterator expires 15 minutes after it is returned to the requester.

    Args:
        stream_arn(str): The Amazon Resource Name (ARN) for the stream.
        shard_id(str): The identifier of the shard. The iterator will be returned for this shard ID.
        shard_iterator_type(str): Determines how the shard iterator is used to start reading stream records from the shard:    AT_SEQUENCE_NUMBER - Start reading exactly from the position denoted by a specific sequence number.    AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number.    TRIM_HORIZON - Start reading at the last (untrimmed) stream record, which is the oldest record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age exceeds this limit are subject to removal (trimming) from the stream.    LATEST - Start reading just after the most recent stream record in the shard, so that you always read the most recent data in the shard.  .
        sequence_number(str, optional): The sequence number of a stream record in the shard from which to start reading. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodbstream.shard_iterator.get(
                ctx, stream_arn=value, shard_id=value, shard_iterator_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodbstream.shard_iterator.get stream_arn=value, shard_id=value, shard_iterator_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodbstreams",
        operation="get_shard_iterator",
        op_kwargs={
            "StreamArn": stream_arn,
            "ShardId": shard_id,
            "ShardIteratorType": shard_iterator_type,
            "SequenceNumber": sequence_number,
        },
    )
