"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, shard_iterator: str, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the stream records from a given shard. Specify a shard iterator using the ShardIterator parameter. The shard iterator specifies the position in the shard from which you want to start reading stream records sequentially. If there are no stream records available in the portion of the shard that the iterator points to, GetRecords returns an empty list. Note that it might take multiple calls to get to a portion of the shard that contains stream records.   GetRecords can retrieve a maximum of 1 MB of data or 1000 stream records, whichever comes first.

    Args:
        shard_iterator(str): A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be used to access the stream records in this shard.
        limit(int, optional): The maximum number of records to return from the shard. The upper limit is 1000. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodbstream.record.get_all(ctx, shard_iterator=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodbstream.record.get_all shard_iterator=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodbstreams",
        operation="get_records",
        op_kwargs={"ShardIterator": shard_iterator, "Limit": limit},
    )
