"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, table_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gives a description of the Time to Live (TTL) status on the specified table.

    Args:
        table_name(str): The name of the table to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.time_to_live.describe(ctx, table_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.time_to_live.describe table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_time_to_live",
        op_kwargs={"TableName": table_name},
    )


async def update(hub, ctx, table_name: str, time_to_live_specification: Dict) -> Dict:
    r"""
    **Autogenerated function**

    The UpdateTimeToLive method enables or disables Time to Live (TTL) for the specified table. A successful UpdateTimeToLive call returns the current TimeToLiveSpecification. It can take up to one hour for the change to fully process. Any additional UpdateTimeToLive calls for the same table during this one hour duration result in a ValidationException.  TTL compares the current time in epoch time format to the time stored in the TTL attribute of an item. If the epoch time value stored in the attribute is less than the current time, the item is marked as expired and subsequently deleted.   The epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.   DynamoDB deletes expired items on a best-effort basis to ensure availability of throughput for other data operations.   DynamoDB typically deletes expired items within two days of expiration. The exact duration within which an item gets deleted after expiration is specific to the nature of the workload. Items that have expired and not been deleted will still show up in reads, queries, and scans.  As items are deleted, they are removed from any local secondary index and global secondary index immediately in the same eventually consistent way as a standard delete operation. For more information, see Time To Live in the Amazon DynamoDB Developer Guide.

    Args:
        table_name(str): The name of the table to be configured.
        time_to_live_specification(Dict): Represents the settings used to enable or disable Time to Live for the specified table.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.time_to_live.update(
                ctx, table_name=value, time_to_live_specification=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.time_to_live.update table_name=value, time_to_live_specification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="update_time_to_live",
        op_kwargs={
            "TableName": table_name,
            "TimeToLiveSpecification": time_to_live_specification,
        },
    )
