"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def export(
    hub,
    ctx,
    table_arn: str,
    s3_bucket: str,
    export_time: str = None,
    client_token: str = None,
    s3_bucket_owner: str = None,
    s3_prefix: str = None,
    s3_sse_algorithm: str = None,
    s3_sse_kms_key_id: str = None,
    export_format: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Exports table data to an S3 bucket. The table must have point in time recovery enabled, and you can export data from any time within the point in time recovery window.

    Args:
        table_arn(str): The Amazon Resource Name (ARN) associated with the table to export.
        export_time(str, optional): Time in the past from which to export table data. The table export will be a snapshot of the table's state at this point in time. Defaults to None.
        client_token(str, optional): Providing a ClientToken makes the call to ExportTableToPointInTimeInput idempotent, meaning that multiple identical calls have the same effect as one single call. A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 8 hours, or the result might not be idempotent. If you submit a request with the same client token but a change in other parameters within the 8-hour idempotency window, DynamoDB returns an IdempotentParameterMismatch exception. Defaults to None.
        s3_bucket(str): The name of the Amazon S3 bucket to export the snapshot to.
        s3_bucket_owner(str, optional): The ID of the AWS account that owns the bucket the export will be stored in. Defaults to None.
        s3_prefix(str, optional): The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot. Defaults to None.
        s3_sse_algorithm(str, optional): Type of encryption used on the bucket where export data will be stored. Valid values for S3SseAlgorithm are:    AES256 - server-side encryption with Amazon S3 managed keys    KMS - server-side encryption with AWS KMS managed keys  . Defaults to None.
        s3_sse_kms_key_id(str, optional): The ID of the AWS KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable). Defaults to None.
        export_format(str, optional): The format for the exported data. Valid values for ExportFormat are DYNAMODB_JSON or ION. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.to_point_in_time.export(
                ctx, table_arn=value, s3_bucket=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.to_point_in_time.export table_arn=value, s3_bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="export_table_to_point_in_time",
        op_kwargs={
            "TableArn": table_arn,
            "ExportTime": export_time,
            "ClientToken": client_token,
            "S3Bucket": s3_bucket,
            "S3BucketOwner": s3_bucket_owner,
            "S3Prefix": s3_prefix,
            "S3SseAlgorithm": s3_sse_algorithm,
            "S3SseKmsKeyId": s3_sse_kms_key_id,
            "ExportFormat": export_format,
        },
    )


async def restore(
    hub,
    ctx,
    target_table_name: str,
    source_table_arn: str = None,
    source_table_name: str = None,
    use_latest_restorable_time: bool = None,
    restore_date_time: str = None,
    billing_mode_override: str = None,
    global_secondary_index_override: List = None,
    local_secondary_index_override: List = None,
    provisioned_throughput_override: Dict = None,
    sse_specification_override: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Restores the specified table to the specified point in time within EarliestRestorableDateTime and LatestRestorableDateTime. You can restore your table to any point in time during the last 35 days. Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.   When you restore using point in time recovery, DynamoDB restores your table data to the state based on the selected date and time (day:hour:minute:second) to a new table.   Along with data, the following are also included on the new restored table using point in time recovery:    Global secondary indexes (GSIs)   Local secondary indexes (LSIs)   Provisioned read and write capacity   Encryption settings   All these settings come from the current settings of the source table at the time of restore.     You must manually set up the following on the restored table:   Auto scaling policies   IAM policies   Amazon CloudWatch metrics and alarms   Tags   Stream settings   Time to Live (TTL) settings   Point in time recovery settings

    Args:
        source_table_arn(str, optional): The DynamoDB table that will be restored. This value is an Amazon Resource Name (ARN). Defaults to None.
        source_table_name(str, optional): Name of the source table that is being restored. Defaults to None.
        target_table_name(str): The name of the new table to which it must be restored to.
        use_latest_restorable_time(bool, optional): Restore the table to the latest possible time. LatestRestorableDateTime is typically 5 minutes before the current time. . Defaults to None.
        restore_date_time(str, optional): Time in the past to restore the table to. Defaults to None.
        billing_mode_override(str, optional): The billing mode of the restored table. Defaults to None.
        global_secondary_index_override(List, optional): List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore. Defaults to None.
        local_secondary_index_override(List, optional): List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore. Defaults to None.
        provisioned_throughput_override(Dict, optional): Provisioned throughput settings for the restored table. Defaults to None.
        sse_specification_override(Dict, optional): The new server-side encryption settings for the restored table. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.to_point_in_time.restore(
                ctx, target_table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.to_point_in_time.restore target_table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="restore_table_to_point_in_time",
        op_kwargs={
            "SourceTableArn": source_table_arn,
            "SourceTableName": source_table_name,
            "TargetTableName": target_table_name,
            "UseLatestRestorableTime": use_latest_restorable_time,
            "RestoreDateTime": restore_date_time,
            "BillingModeOverride": billing_mode_override,
            "GlobalSecondaryIndexOverride": global_secondary_index_override,
            "LocalSecondaryIndexOverride": local_secondary_index_override,
            "ProvisionedThroughputOverride": provisioned_throughput_override,
            "SSESpecificationOverride": sse_specification_override,
        },
    )
