"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, table_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes auto scaling settings across replicas of the global table at once.  This operation only applies to Version 2019.11.21 of global tables.

    Args:
        table_name(str): The name of the table.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.replica_auto_scaling.describe(
                ctx, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.replica_auto_scaling.describe table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_table_replica_auto_scaling",
        op_kwargs={"TableName": table_name},
    )


async def update(
    hub,
    ctx,
    table_name: str,
    global_secondary_index_updates: List = None,
    provisioned_write_capacity_auto_scaling_update: Dict = None,
    replica_updates: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates auto scaling settings on your global tables at once.  This operation only applies to Version 2019.11.21 of global tables.

    Args:
        global_secondary_index_updates(List, optional): Represents the auto scaling settings of the global secondary indexes of the replica to be updated. Defaults to None.
        table_name(str): The name of the global table to be updated.
        provisioned_write_capacity_auto_scaling_update(Dict, optional): Represents the auto scaling settings to be modified for a global table or global secondary index. Defaults to None.
        replica_updates(List, optional): Represents the auto scaling settings of replicas of the table that will be modified. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.replica_auto_scaling.update(
                ctx, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.replica_auto_scaling.update table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="update_table_replica_auto_scaling",
        op_kwargs={
            "GlobalSecondaryIndexUpdates": global_secondary_index_updates,
            "TableName": table_name,
            "ProvisionedWriteCapacityAutoScalingUpdate": provisioned_write_capacity_auto_scaling_update,
            "ReplicaUpdates": replica_updates,
        },
    )
