"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    attribute_definitions: List,
    table_name: str,
    key_schema: List,
    local_secondary_indexes: List = None,
    global_secondary_indexes: List = None,
    billing_mode: str = None,
    provisioned_throughput: Dict = None,
    stream_specification: Dict = None,
    sse_specification: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The CreateTable operation adds a new table to your account. In an AWS account, table names must be unique within each Region. That is, you can have two tables with same name if you create the tables in different Regions.  CreateTable is an asynchronous operation. Upon receiving a CreateTable request, DynamoDB immediately returns a response with a TableStatus of CREATING. After the table is created, DynamoDB sets the TableStatus to ACTIVE. You can perform read and write operations only on an ACTIVE table.  You can optionally define secondary indexes on the new table, as part of the CreateTable operation. If you want to create multiple tables with secondary indexes on them, you must create the tables sequentially. Only one table with secondary indexes can be in the CREATING state at any given time. You can use the DescribeTable action to check the table status.

    Args:
        attribute_definitions(List): An array of attributes that describe the key schema for the table and indexes.
        table_name(str): The name of the table to create.
        key_schema(List): Specifies the attributes that make up the primary key for a table or an index. The attributes in KeySchema must also be defined in the AttributeDefinitions array. For more information, see Data Model in the Amazon DynamoDB Developer Guide. Each KeySchemaElement in the array is composed of:    AttributeName - The name of this key attribute.    KeyType - The role that the key attribute will assume:    HASH - partition key    RANGE - sort key      The partition key of an item is also known as its hash attribute. The term "hash attribute" derives from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values. The sort key of an item is also known as its range attribute. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.  For a simple primary key (partition key), you must provide exactly one element with a KeyType of HASH. For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order: The first element must have a KeyType of HASH, and the second element must have a KeyType of RANGE. For more information, see Working with Tables in the Amazon DynamoDB Developer Guide.
        local_secondary_indexes(List, optional): One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local secondary index is unconstrained. Each local secondary index in the array includes the following:    IndexName - The name of the local secondary index. Must be unique only for this table.     KeySchema - Specifies the key schema for the local secondary index. The key schema must begin with the same partition key as the table.    Projection - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:    ProjectionType - One of the following:    KEYS_ONLY - Only the index and primary keys are projected into the index.    INCLUDE - Only the specified table attributes are projected into the index. The list of projected attributes is in NonKeyAttributes.    ALL - All of the table attributes are projected into the index.      NonKeyAttributes - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in NonKeyAttributes, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.    . Defaults to None.
        global_secondary_indexes(List, optional): One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index in the array includes the following:    IndexName - The name of the global secondary index. Must be unique only for this table.     KeySchema - Specifies the key schema for the global secondary index.    Projection - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:    ProjectionType - One of the following:    KEYS_ONLY - Only the index and primary keys are projected into the index.    INCLUDE - Only the specified table attributes are projected into the index. The list of projected attributes is in NonKeyAttributes.    ALL - All of the table attributes are projected into the index.      NonKeyAttributes - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in NonKeyAttributes, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.      ProvisionedThroughput - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units.  . Defaults to None.
        billing_mode(str, optional): Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.    PROVISIONED - We recommend using PROVISIONED for predictable workloads. PROVISIONED sets the billing mode to Provisioned Mode.    PAY_PER_REQUEST - We recommend using PAY_PER_REQUEST for unpredictable workloads. PAY_PER_REQUEST sets the billing mode to On-Demand Mode.   . Defaults to None.
        provisioned_throughput(Dict, optional): Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the UpdateTable operation.  If you set BillingMode as PROVISIONED, you must specify this property. If you set BillingMode as PAY_PER_REQUEST, you cannot specify this property. For current minimum and maximum provisioned throughput values, see Service, Account, and Table Quotas in the Amazon DynamoDB Developer Guide. Defaults to None.
        stream_specification(Dict, optional): The settings for DynamoDB Streams on the table. These settings consist of:    StreamEnabled - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).    StreamViewType - When an item in the table is modified, StreamViewType determines what information is written to the table's stream. Valid values for StreamViewType are:    KEYS_ONLY - Only the key attributes of the modified item are written to the stream.    NEW_IMAGE - The entire item, as it appears after it was modified, is written to the stream.    OLD_IMAGE - The entire item, as it appeared before it was modified, is written to the stream.    NEW_AND_OLD_IMAGES - Both the new and the old item images of the item are written to the stream.    . Defaults to None.
        sse_specification(Dict, optional): Represents the settings used to enable server-side encryption. Defaults to None.
        tags(List, optional): A list of key-value pairs to label the table. For more information, see Tagging for DynamoDB. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.init.create(
                ctx, attribute_definitions=value, table_name=value, key_schema=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.init.create attribute_definitions=value, table_name=value, key_schema=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="create_table",
        op_kwargs={
            "AttributeDefinitions": attribute_definitions,
            "TableName": table_name,
            "KeySchema": key_schema,
            "LocalSecondaryIndexes": local_secondary_indexes,
            "GlobalSecondaryIndexes": global_secondary_indexes,
            "BillingMode": billing_mode,
            "ProvisionedThroughput": provisioned_throughput,
            "StreamSpecification": stream_specification,
            "SSESpecification": sse_specification,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, table_name: str) -> Dict:
    r"""
    **Autogenerated function**

    The DeleteTable operation deletes a table and all of its items. After a DeleteTable request, the specified table is in the DELETING state until DynamoDB completes the deletion. If the table is in the ACTIVE state, you can delete it. If a table is in CREATING or UPDATING states, then DynamoDB returns a ResourceInUseException. If the specified table does not exist, DynamoDB returns a ResourceNotFoundException. If table is already in the DELETING state, no error is returned.   DynamoDB might continue to accept data read and write operations, such as GetItem and PutItem, on a table in the DELETING state until the table deletion is complete.  When you delete a table, any indexes on that table are also deleted. If you have DynamoDB Streams enabled on the table, then the corresponding stream on that table goes into the DISABLED state, and the stream is automatically deleted after 24 hours. Use the DescribeTable action to check the status of the table.

    Args:
        table_name(str): The name of the table to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.init.delete(ctx, table_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.init.delete table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="delete_table",
        op_kwargs={"TableName": table_name},
    )


async def describe(hub, ctx, table_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the table, including the current status of the table, when it was created, the primary key schema, and any indexes on the table.  If you issue a DescribeTable request immediately after a CreateTable request, DynamoDB might return a ResourceNotFoundException. This is because DescribeTable uses an eventually consistent query, and the metadata for your table might not be available at that moment. Wait for a few seconds, and then try the DescribeTable request again.

    Args:
        table_name(str): The name of the table to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.init.describe(ctx, table_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.init.describe table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_table",
        op_kwargs={"TableName": table_name},
    )


async def list_all(
    hub, ctx, exclusive_start_table_name: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of table names associated with the current account and endpoint. The output from ListTables is paginated, with each page returning a maximum of 100 table names.

    Args:
        exclusive_start_table_name(str, optional): The first table name that this operation will evaluate. Use the value that was returned for LastEvaluatedTableName in a previous operation, so that you can obtain the next page of results. Defaults to None.
        limit(int, optional): A maximum number of table names to return. If this parameter is not specified, the limit is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="list_tables",
        op_kwargs={
            "ExclusiveStartTableName": exclusive_start_table_name,
            "Limit": limit,
        },
    )


async def update(
    hub,
    ctx,
    table_name: str,
    attribute_definitions: List = None,
    billing_mode: str = None,
    provisioned_throughput: Dict = None,
    global_secondary_index_updates: List = None,
    stream_specification: Dict = None,
    sse_specification: Dict = None,
    replica_updates: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table. You can only perform one of the following operations at once:   Modify the provisioned throughput settings of the table.   Enable or disable DynamoDB Streams on the table.   Remove a global secondary index from the table.   Create a new global secondary index on the table. After the index begins backfilling, you can use UpdateTable to perform other operations.    UpdateTable is an asynchronous operation; while it is executing, the table status changes from ACTIVE to UPDATING. While it is UPDATING, you cannot issue another UpdateTable request. When the table returns to the ACTIVE state, the UpdateTable operation is complete.

    Args:
        attribute_definitions(List, optional): An array of attributes that describe the key schema for the table and indexes. If you are adding a new global secondary index to the table, AttributeDefinitions must include the key element(s) of the new index. Defaults to None.
        table_name(str): The name of the table to be updated.
        billing_mode(str, optional): Controls how you are charged for read and write throughput and how you manage capacity. When switching from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial provisioned capacity values are estimated based on the consumed read and write capacity of your table and global secondary indexes over the past 30 minutes.    PROVISIONED - We recommend using PROVISIONED for predictable workloads. PROVISIONED sets the billing mode to Provisioned Mode.    PAY_PER_REQUEST - We recommend using PAY_PER_REQUEST for unpredictable workloads. PAY_PER_REQUEST sets the billing mode to On-Demand Mode.   . Defaults to None.
        provisioned_throughput(Dict, optional): The new provisioned throughput settings for the specified table or index. Defaults to None.
        global_secondary_index_updates(List, optional): An array of one or more global secondary indexes for the table. For each index in the array, you can request one action:    Create - add a new global secondary index to the table.    Update - modify the provisioned throughput settings of an existing global secondary index.    Delete - remove a global secondary index from the table.   You can create or delete only one global secondary index per UpdateTable operation. For more information, see Managing Global Secondary Indexes in the Amazon DynamoDB Developer Guide. . Defaults to None.
        stream_specification(Dict, optional): Represents the DynamoDB Streams configuration for the table.  You receive a ResourceInUseException if you try to enable a stream on a table that already has a stream, or if you try to disable a stream on a table that doesn't have a stream. . Defaults to None.
        sse_specification(Dict, optional): The new server-side encryption settings for the specified table. Defaults to None.
        replica_updates(List, optional): A list of replica update actions (create, delete, or update) for the table.  This property only applies to Version 2019.11.21 of global tables. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.init.update(ctx, table_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.init.update table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="update_table",
        op_kwargs={
            "AttributeDefinitions": attribute_definitions,
            "TableName": table_name,
            "BillingMode": billing_mode,
            "ProvisionedThroughput": provisioned_throughput,
            "GlobalSecondaryIndexUpdates": global_secondary_index_updates,
            "StreamSpecification": stream_specification,
            "SSESpecification": sse_specification,
            "ReplicaUpdates": replica_updates,
        },
    )
