"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def restore(
    hub,
    ctx,
    target_table_name: str,
    backup_arn: str,
    billing_mode_override: str = None,
    global_secondary_index_override: List = None,
    local_secondary_index_override: List = None,
    provisioned_throughput_override: Dict = None,
    sse_specification_override: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new table from an existing backup. Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.  You can call RestoreTableFromBackup at a maximum rate of 10 times per second. You must manually set up the following on the restored table:   Auto scaling policies   IAM policies   Amazon CloudWatch metrics and alarms   Tags   Stream settings   Time to Live (TTL) settings

    Args:
        target_table_name(str): The name of the new table to which the backup must be restored.
        backup_arn(str): The Amazon Resource Name (ARN) associated with the backup.
        billing_mode_override(str, optional): The billing mode of the restored table. Defaults to None.
        global_secondary_index_override(List, optional): List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore. Defaults to None.
        local_secondary_index_override(List, optional): List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore. Defaults to None.
        provisioned_throughput_override(Dict, optional): Provisioned throughput settings for the restored table. Defaults to None.
        sse_specification_override(Dict, optional): The new server-side encryption settings for the restored table. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.table.from_backup.restore(
                ctx, target_table_name=value, backup_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.table.from_backup.restore target_table_name=value, backup_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="restore_table_from_backup",
        op_kwargs={
            "TargetTableName": target_table_name,
            "BackupArn": backup_arn,
            "BillingModeOverride": billing_mode_override,
            "GlobalSecondaryIndexOverride": global_secondary_index_override,
            "LocalSecondaryIndexOverride": local_secondary_index_override,
            "ProvisionedThroughputOverride": provisioned_throughput_override,
            "SSESpecificationOverride": sse_specification_override,
        },
    )
