"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def execute(
    hub,
    ctx,
    statement: str,
    parameters: List = None,
    consistent_read: bool = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This operation allows you to perform reads and singleton writes on data stored in DynamoDB, using PartiQL.

    Args:
        statement(str):  The PartiQL statement representing the operation to run. .
        parameters(List, optional):  The parameters for the PartiQL statement, if any. . Defaults to None.
        consistent_read(bool, optional):  The consistency of a read operation. If set to true, then a strongly consistent read is used; otherwise, an eventually consistent read is used. . Defaults to None.
        next_token(str, optional):  Set this value to get remaining results, if NextToken was returned in the statement response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.statement.execute(ctx, statement=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.statement.execute statement=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="execute_statement",
        op_kwargs={
            "Statement": statement,
            "Parameters": parameters,
            "ConsistentRead": consistent_read,
            "NextToken": next_token,
        },
    )
