"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Associate a set of tags with an Amazon DynamoDB resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking. You can call TagResource up to five times per second, per account.  For an overview on tagging DynamoDB resources, see Tagging for DynamoDB in the Amazon DynamoDB Developer Guide.

    Args:
        resource_arn(str): Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource Name (ARN).
        tags(List): The tags to be assigned to the Amazon DynamoDB resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes the association of tags from an Amazon DynamoDB resource. You can call UntagResource up to five times per second, per account.  For an overview on tagging DynamoDB resources, see Tagging for DynamoDB in the Amazon DynamoDB Developer Guide.

    Args:
        resource_arn(str): The DynamoDB resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).
        tag_keys(List): A list of tag keys. Existing tags of the resource whose keys are members of this list will be removed from the DynamoDB resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.resource.untag(ctx, resource_arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
